/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describes the configurable properties for an struct
 * converter. One or more struct converters can be declared as part of an entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.StructConverter
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalStructConverter extends ExternalConverter {

	/**
	 * The attribute name used to store and retrieve the converter property.
	 */
	String CONVERTER = "converter";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String STRUCT_CONVERTER = "struct-converter";

	/**
	 * Returns the class name of the converter class.
	 */
	String getConverter();

	/**
	 * Returns the {@link TextRange} for the class name of the converter class.
	 */
	TextRange getConverterTextRange();

	/**
	 * Sets the class name of the converter class.
	 */
	void setConverter(String classname);
}