/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.utility.TextRange;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

/**
 * Defines the properties of a Table Generator defined in the ORM.xml. A Table Generator may be
 * owned the root of the ORM xml (entity-mappings), an Entity or an Entity's ID definition.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalTableGenerator extends ExternalPrimaryKeyGenerator {

	/**
	 * The attribute name used to store and retrieve the temporal property.
	 */
	String PK_COLUMN_NAME = "pk-column-name";

	/**
	 * The attribute name used to store and retrieve the temporal property.
	 */
	String PK_COLUMN_VALUE = "pk-column-value";

	/**
	 * The attribute name used to store and retrieve the temporal property.
	 */
	String TABLE = "table";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String TABLE_GENERATOR = "table-generator";

	/**
	 * The attribute name used to store and retrieve the temporal property.
	 */
	String VALUE_COLUMN_NAME = "value-column-name";

	/**
	 * Adds a unique constraint with the given column names to this table generator.
	 */
	ExternalUniqueConstraint addUniqueConstraint(ListIterable<String> columnNames);

	/**
	 * Returns the name of the Primary Key column for the generated table.
	 */
	String getPKColumnName();

	/**
	 * Returns the {@link TextRange} of the primary key column.
	 */
	TextRange getPKColumnNameTextRange();

	/**
	 * Returns the value for the primary key column.
	 */
	String getPKColumnValue();

	/**
	 * Returns the {@link TextRange} of the primary key column value.
	 */
	TextRange getPKColumnValueTextRange();

	/**
	 * Returns the name of the table that will be generated.
	 */
	String getTableName();

	/**
	 * Returns the {@link TextRange} of this generator's table name.
	 */
	TextRange getTableNameTextRange();

	/**
	 * Returns a unique constraint that has been defined at the given position.
	 */
	ExternalUniqueConstraint getUniqueConstraint(int index);

	/**
	 * Returns the value column name.
	 */
	String getValueColumnName();

	/**
	 * Returns {@link TextRange} the value column name.
	 */
	TextRange getValueColumnNameTextRange();

	/**
	 * Removes a unique constraint from this table generator at the given position.
	 */
	void removeUniqueConstraint(int index);

	/**
	 * Set the PK column name.
	 */
	void setPKColumnName(String name);

	/**
	 * Set the PK column value.
	 */
	void setPKColumnValue(String value);

	/**
	 * Set the table name.
	 */
	void setTableName(String name);

	/**
	 * Set the value column name.
	 */
	void setValueColumnName(String name);

	/**
	 * List of all unique constraints known to this table generator.
	 */
	List<ExternalUniqueConstraint> uniqueConstraints();

	/**
	 * The count of all unique constraints known to this table generator.
	 */
	int uniqueConstraintsSize();
}