/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.annotations.TenantTableDiscriminatorType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;


/**
 * This interface and inherited behavior describes the configurable properties
 * for an tenant table discriminator. One table can be declared on a Multitenant
 *
 * @see org.eclipse.persistence.annotations.TenantTableDiscriminator
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalTenantTableDiscriminator extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the context-property property.
	 */
	String CONTEXT_PROPERTY = "context-property";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String TENANT_TABLE_DISCRIMINATOR = "tenant-table-discriminator";

	/**
	 * The attribute name used to store and retrieve the tenant-table-discriminator-type property.
	 */
	String TENANT_TABLE_DISCRIMINATOR_TYPE = "type";

	/**
	 * Returns the context property of the table.
	 */
	String getContextProperty();

	/**
	 * Returns the {@link TextRange} for the context property of the table.
	 */
	TextRange getContextPropertyTextRange();

	/**
	 * Type of the discriminator.
	 */
	TenantTableDiscriminatorType getDiscriminatorType();

	/**
	 * Returns the {@link TextRange} for the discriminator type of the table.
	 */
	TextRange getDiscriminatorTypeTextRange();

	/**
	 * Set the context property for the column
	 */
	void setContextProperty(String contextProperty);

	/**
	 * Set the discriminator type
	 */
	void setDiscriminatorType(TenantTableDiscriminatorType type);

}
