/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.DiscriminatorType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalDiscriminatorColumn;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * The external form of the discriminator column.
 *
 * @see Entity
 * @see VariableOneToOneMapping
 *
 * @version 2.6
 */
final class DiscriminatorColumn extends AbstractExternalForm
                                implements ExternalDiscriminatorColumn {

	/**
	 * Creates a new <code>DiscriminatorColumn</code>.
	 *
	 * @param parent The parent of this external form
	 */
	DiscriminatorColumn(AbstractExternalForm parent) {
		super(parent);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(NAME);
		names.add(DISCRIMINATOR_TYPE);
		names.add(COLUMN_DEFINITION);
		names.add(LENGTH);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getColumnDefinition() {
		return getAttribute(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getColumnDefinitionTextRange() {
		return getAttributeTextRange(COLUMN_DEFINITION);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public DiscriminatorType getDiscriminatorType() {
		return getEnumAttribute(DISCRIMINATOR_TYPE, DiscriminatorType.class);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getDiscriminatorTypeTextRange() {
		return getAttributeTextRange(DISCRIMINATOR_TYPE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return DISCRIMINATOR_COLUMN;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Integer getLength() {
		return getIntegerAttribute(LENGTH);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getLengthTextRange() {
		return getAttributeTextRange(LENGTH);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public TextRange getNameTextRange() {
		return getAttributeTextRange(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setColumnDefinition(String definition) {

		setAttribute(COLUMN_DEFINITION, definition);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDiscriminatorType(DiscriminatorType type) {

		setAttribute(DISCRIMINATOR_TYPE, type);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setLength(Integer length) {

		setAttribute(LENGTH, length);

		if (!hasAnything()) {
			removeSelf();
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {

		setAttribute(NAME, name);

		if (!hasAnything()) {
			removeSelf();
		}
	}
}