/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlJoinField;
import org.w3c.dom.Element;

/**
 * The external form for {@link org.eclipse.persistence.nosql.annotations.JoinField JoinField}
 *
 * @version 2.6
 * @since 2.5
 */
final class NoSqlJoinField extends AbstractExternalForm
                           implements ExternalNoSqlJoinField {

	/**
	 * The position of the join field within the list of the same type.
	 */
	private int index;

	/**
	 * Creates a new <code>NoSqlJoinField</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the join field within the list of the same type
	 */
	NoSqlJoinField(AbstractExternalForm parent, int index) {
		super(parent);
		this.index = index;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
		if (elementName == getElementName()) {
			index = index(parent, child, elementName);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Element getElement() {
		return getChild(getParent(), getElementName(), index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return JOIN_FIELD;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getName() {
		return getAttribute(NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getReferencedFieldName() {
		return getAttribute(REFERENCED_FIELD_NAME);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setName(String name) {
		setAttribute(NAME, name);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setReferencedFieldName(String name) {
		setAttribute(REFERENCED_FIELD_NAME, name);
	}
}