/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
******************************************************************************/
package org.eclipse.persistence.tools.db.relational.handles;

import org.eclipse.persistence.tools.db.relational.ELModel;
import org.eclipse.persistence.tools.db.relational.ELReference;
import org.eclipse.persistence.tools.utility.node.Node;

/**
 * MWReferenceHandle is used to isolate the painful bits of code
 * necessary to correctly handle references to MWReferences.
 * Since a MWReference is nested within the XML file
 * for a MWTable, we need to store a reference to a particular
 * reference as a pair of instance variables:
 *   - the name of the containing table
 *   - the name of the reference
 *
 * This causes no end of pain when dealing with TopLink, property
 * change listeners, backward-compatibility, etc.
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public final class MWReferenceHandle extends MWHandle {

	/**
	 * This is the actual reference.
	 * It is built from the table and reference names, below.
	 */
	private volatile ELReference reference;

	/**
	 * The table and reference names are transient. They
	 * are used only to hold their values until postProjectBuild()
	 * is called and we can resolve the actual reference.
	 * We do not keep these in synch with the reference itself because
	 * we cannot know when the reference has been renamed etc.
	 */
	private volatile String referenceTableName;
	private volatile String referenceName;

	// ********** constructors **********

	/**
	 * default constructor - for TopLink use only
	 */
	@SuppressWarnings("unused")
	private MWReferenceHandle() {
		super();
	}

	public MWReferenceHandle(ELModel parent, NodeReferenceScrubber scrubber) {
		super(parent, scrubber);
	}

	public MWReferenceHandle(ELModel parent, ELReference reference, NodeReferenceScrubber scrubber) {
		super(parent, scrubber);
		this.reference = reference;
	}


	// ********** instance methods **********

	public ELReference getReference() {
		return this.reference;
	}

	public void setReference(ELReference reference) {
		this.reference = reference;
	}

	@Override
	protected Node node() {
		return getReference();
	}

	public MWReferenceHandle setScrubber(NodeReferenceScrubber scrubber) {
		this.setScrubberInternal(scrubber);
		return this;
	}

	@Override
	public void toString(StringBuffer sb) {
		if (this.reference == null) {
			sb.append("null");
		} else {
			this.reference.toString(sb);
		}
	}
}