/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalTransformationMapping;

/**
 * This unit-tests tests the behavior of {@link ExternalTransformationMapping}.
 *
 * @version 2.6
 */
public final class TransformationMappingTests extends NonTriensientMappingTests<ExternalTransformationMapping> {

	/**
	 * {@inheritDoc}
	 */
	@Override
	void addAttributeTesters(RootNodeTester tester) {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	void addChildTesters(RootNodeTester tester) {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	ExternalTransformationMapping addMapping(ExternalEntity entity) {
		return entity.addTransformationMapping(mappingName());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	String elementName() {
		return ExternalTransformationMapping.TRANSFORMATION;
	}
}