/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.gen.nosql.mongo.meta;

/**
 * This class describes the metadata of MongoDB column that is a leaf 
 * value (non-nested).
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *  
 * @author John Bracken
 * @version 2.6
 */
public final class LeafColumnDescriptor extends ColumnDescriptor {

	/** The type of the column. */
	private Class<?> columnType;
	
	/**
	 * Constructor. 
	 * 
	 * @param columName name of the column.
	 */
	public LeafColumnDescriptor(String columName) {
		super(columName);
	}
	
	/**
	 * Returns the Java type of the column.
	 * 
	 * @return the Java type of the column.
	 */
	public Class<?> getColumnType() {
		return this.columnType;
	}

	/**
	 * Sets the Java type of the column.
	 * 
	 * @param columnType the Java type of the column.
	 */
	public void setColumnType(Class<?> columnType) {
		this.columnType = columnType;
	}
}
