/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;

public class IndirectMap<K, V>
extends Hashtable<K, V>
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Hashtable<K, V> delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 11;
    protected float loadFactor = 0.75f;

    public IndirectMap() {
        this(11);
    }

    public IndirectMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IndirectMap(int initialCapacity, float loadFactor) {
        super(0);
        this.initialize(initialCapacity, loadFactor);
    }

    public IndirectMap(Map<? extends K, ? extends V> m) {
        super(0);
        this.initialize(m);
    }

    protected Hashtable<K, V> buildDelegate() {
        Hashtable value = (Hashtable)this.getValueHolder().getValue();
        if (value == null) {
            value = new Hashtable(this.initialCapacity, this.loadFactor);
        }
        return value;
    }

    @Override
    public synchronized void clear() {
        if (this.hasTrackedPropertyChangeListener()) {
            Iterator<K> objects = this.keySet().iterator();
            while (objects.hasNext()) {
                K o = objects.next();
                objects.remove();
                this.raiseRemoveChangeEvent(o, this.get(o));
            }
        } else {
            this.getDelegate().clear();
        }
    }

    @Override
    public void clearDeferredChanges() {
    }

    @Override
    public synchronized Object clone() {
        IndirectMap result = (IndirectMap)super.clone();
        result.delegate = (Hashtable)this.getDelegate().clone();
        result.valueHolder = new ValueHolder(result.delegate);
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    @Override
    public synchronized boolean contains(Object value) {
        return this.getDelegate().contains(value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.getDelegate().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getDelegate().containsValue(value);
    }

    @Override
    public synchronized Enumeration<V> elements() {
        return this.getDelegate().elements();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new Set<Map.Entry<K, V>>(){
            Set<Map.Entry<K, V>> delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> delegateIterator;
                    Map.Entry<K, V> currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject.getKey(), this.currentObject.getValue());
                        this.delegateIterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.delegateSet.toArray(a);
            }

            @Override
            public boolean add(Map.Entry<K, V> o) {
                return this.delegateSet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)o).getKey()) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.delegateSet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                return this.delegateSet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Map.Entry object = objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object.getKey(), object.getValue());
                    result = true;
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                for (Object object : c) {
                    Object removed;
                    if (!(object instanceof Map.Entry) || (removed = IndirectMap.this.remove(((Map.Entry)object).getKey())) == null) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateSet.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }
        };
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this.getDelegate().equals(o);
    }

    @Override
    public synchronized V get(Object key) {
        return this.getDelegate().get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable<K, V> getDelegate() {
        if (this.delegate == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    @Override
    public Object getDelegateObject() {
        return this.getDelegate();
    }

    @Override
    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    @Override
    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Hashtable(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return this.valueHolder;
    }

    @Override
    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    protected void initialize(int initialCapacity, float loadFactor) {
        this.delegate = null;
        this.loadFactor = loadFactor;
        this.initialCapacity = initialCapacity;
        this.valueHolder = null;
    }

    protected void initialize(Map<? extends K, ? extends V> m) {
        this.delegate = null;
        Hashtable<? extends K, ? extends V> temp = new Hashtable<K, V>(m);
        this.valueHolder = new ValueHolder(temp);
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    @Override
    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    @Override
    public synchronized Enumeration<K> keys() {
        return this.getDelegate().keys();
    }

    @Override
    public Set<K> keySet() {
        return new Set<K>(){
            Set<K> delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            @Override
            public int size() {
                return this.delegateSet.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateSet.contains(o);
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    Iterator<K> delegateIterator;
                    K currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject, IndirectMap.this.getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            @Override
            public Object[] toArray(Object[] a) {
                return this.delegateSet.toArray(a);
            }

            @Override
            public boolean add(K o) {
                return this.delegateSet.add(o);
            }

            @Override
            public boolean remove(Object o) {
                return IndirectMap.this.remove(o) != null;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.delegateSet.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                return this.delegateSet.addAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean result = false;
                Iterator objects = this.delegateSet.iterator();
                while (objects.hasNext()) {
                    Object object = objects.next();
                    if (c.contains(object)) continue;
                    objects.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(object, IndirectMap.this.getDelegate().get(object));
                    result = true;
                }
                return result;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                Iterator<?> cs = c.iterator();
                while (cs.hasNext()) {
                    if (IndirectMap.this.remove(cs.next()) == null) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateSet.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateSet.hashCode();
            }
        };
    }

    @Override
    public synchronized V put(K key, V value) {
        V oldValue = this.getDelegate().put(key, value);
        if (oldValue != null) {
            this.raiseRemoveChangeEvent(key, oldValue);
        }
        this.raiseAddChangeEvent(key, value);
        return oldValue;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        if (this.hasTrackedPropertyChangeListener()) {
            for (K key : t.keySet()) {
                this.put(key, t.get(key));
            }
        } else {
            this.getDelegate().putAll(t);
        }
    }

    @Override
    protected void rehash() {
        throw new InternalError("unsupported");
    }

    protected void raiseAddChangeEvent(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value, CollectionChangeEvent.ADD, true));
        }
    }

    protected void raiseRemoveChangeEvent(Object key, Object value) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, key, value, CollectionChangeEvent.REMOVE, true));
        }
    }

    @Override
    public synchronized V remove(Object key) {
        V value = this.getDelegate().remove(key);
        if (value != null) {
            this.raiseRemoveChangeEvent(key, value);
        }
        return value;
    }

    @Override
    public void setTrackedAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    @Override
    public void _persistence_setPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.delegate = null;
        this.valueHolder = valueHolder;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public void setUseLazyInstantiation(boolean useLazyInstantiation) {
    }

    @Override
    public Collection getRemovedElements() {
        return null;
    }

    @Override
    public Collection getAddedElements() {
        return null;
    }

    @Override
    public boolean hasDeferredChanges() {
        return false;
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    @Override
    public Collection<V> values() {
        return new Collection<V>(){
            protected Collection<V> delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            @Override
            public int size() {
                return this.delegateCollection.size();
            }

            @Override
            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                return this.delegateCollection.contains(o);
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    Iterator<V> delegateIterator;
                    V currentObject;
                    {
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    @Override
                    public V next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    @Override
                    public void remove() {
                        for (Map.Entry entry : IndirectMap.this.getDelegate().entrySet()) {
                            if (!entry.getValue().equals(this.currentObject)) continue;
                            IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                        }
                        this.delegateIterator.remove();
                    }
                };
            }

            @Override
            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            @Override
            public <T> T[] toArray(T[] a) {
                return this.delegateCollection.toArray(a);
            }

            @Override
            public boolean add(V o) {
                return this.delegateCollection.add(o);
            }

            @Override
            public boolean remove(Object o) {
                Iterator iterator = IndirectMap.this.getDelegate().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue().equals(o)) {
                        IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.delegateCollection.containsAll(c);
            }

            @Override
            public boolean addAll(Collection<? extends V> c) {
                return this.delegateCollection.addAll(c);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean result = false;
                Iterator<?> iterator = c.iterator();
                while (iterator.hasNext()) {
                    if (!this.remove(iterator.next())) continue;
                    result = true;
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean result = false;
                Iterator iterator = IndirectMap.this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (c.contains(entry.getValue())) continue;
                    iterator.remove();
                    result = true;
                }
                return result;
            }

            @Override
            public void clear() {
                IndirectMap.this.clear();
            }

            @Override
            public boolean equals(Object o) {
                return this.delegateCollection.equals(o);
            }

            @Override
            public int hashCode() {
                return this.delegateCollection.hashCode();
            }
        };
    }
}

