/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class ComplexInheritanceUsingNamedQueryTest
extends JPQLTestCase {
    protected ClassDescriptor descriptor = null;
    protected String argument = null;
    protected QueryException caughtException = null;

    public ComplexInheritanceUsingNamedQueryTest() {
        this.setDescription("Test that EJBQL finder - using a named query - works across inheritance hierarchy");
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor d) {
        this.descriptor = d;
    }

    public void setArgument(String a) {
        this.argument = a;
    }

    public String getArgument() {
        return this.argument;
    }

    @Override
    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Project project = null;
        Vector projects = this.getSomeProjects();
        for (int i = 0; i < projects.size() && !((project = (Project)projects.elementAt(i)) instanceof LargeProject); ++i) {
        }
        this.setArgument(project.getName());
        ReadObjectQuery roq = new ReadObjectQuery();
        roq.setReferenceClass(LargeProject.class);
        ExpressionBuilder eb = new ExpressionBuilder();
        Expression whereClause = eb.get("name").equal((Object)this.getArgument());
        roq.setSelectionCriteria(whereClause);
        Project proj = (Project)this.getSession().executeQuery((DatabaseQuery)roq);
        if (proj == null) {
            this.setOriginalOject(new Vector(0));
        } else {
            this.setOriginalOject(proj);
        }
        this.setUpSessionWithNamedQuery();
    }

    public void setUpSessionWithNamedQuery() {
        String queryName = "findLargeProjectByNameEJBQL";
        if (!this.getSession().containsQuery(queryName)) {
            this.getAbstractSession().addAlias("ProjectBaseClass", this.getSession().getDescriptor(Project.class));
            ReadObjectQuery query = new ReadObjectQuery();
            query.setEJBQLString("SELECT OBJECT(project) FROM ProjectBaseClass project WHERE project.name = ?1");
            query.setName(queryName);
            query.addArgument("1");
            query.setReferenceClass(Project.class);
            this.getSession().addQuery("findLargeProjectByNameEJBQL", (DatabaseQuery)query);
        }
    }

    @Override
    public void test() {
        try {
            Project returnedProject = (Project)this.getSession().executeQuery("findLargeProjectByNameEJBQL", (Object)this.getArgument());
            this.setReturnedObjects(returnedProject);
        }
        catch (QueryException q) {
            this.caughtException = q;
        }
    }

    @Override
    public void verify() throws Exception {
        if (this.caughtException != null) {
            throw new TestErrorException("Test of EJBQL query against inheritance hierarchy failed when using a named query - .\nThis exception thrown while testing case\n----- ComplexInheritanceUsingNamedQueryTest() -----\n" + this.caughtException.getMessage());
        }
        super.verify();
    }

    @Override
    public void reset() {
        this.getSession().removeQuery("findLargeProjectByBudgetEJBQL");
        this.getAbstractSession().getAliasDescriptors().remove("ProjectBaseClass");
        this.setReturnedObjects(null);
        this.setOriginalOject(null);
        super.reset();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

