/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.returning.ProjectAndDatabaseAdapter;
import org.eclipse.persistence.testing.tests.returning.StoredProcedureGeneratorForAdapter;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;

public class InsertUpdateStoredProcedureAdapter
implements ProjectAndDatabaseAdapter {
    StoredProcedureGeneratorForAdapter generator;

    @Override
    public boolean isOriginalSetupRequired() {
        return true;
    }

    @Override
    public void updateProject(Project project, Session session) {
        this.verifySession(session);
        if (this.generator == null) {
            this.generator = new StoredProcedureGeneratorForAdapter(new SchemaManager((DatabaseSession)session));
            this.generator.setUseTableNames(true);
        }
        this.removeOptimisticLocking(project);
        ((DatabaseSession)session).addDescriptors(project);
        this.generator.generateStoredProceduresDefinitionsForProject(project);
        this.generator.amendDescriptors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDatabase(Session session) {
        try {
            this.generator.writeStoredProcedures();
        }
        finally {
            this.clear();
        }
    }

    protected void clear() {
        this.generator = null;
    }

    protected int removeOptimisticLocking(Project project) {
        int removed = 0;
        for (ClassDescriptor desc : project.getDescriptors().values()) {
            if (desc.getOptimisticLockingPolicy() == null) continue;
            desc.setOptimisticLockingPolicy(null);
            ++removed;
        }
        return removed;
    }

    protected void verifySession(Session session) {
        DatabasePlatform platform = session.getPlatform();
        if (((DatabaseSessionImpl)session).getSequencing() != null && ((DatabaseSessionImpl)session).getSequencing().whenShouldAcquireValueForAll() != -1) {
            throw new TestWarningException("InsertUpdateStoredProcedureAdapter can't handle native sequencing on this platform. Use table sequencing instead");
        }
        if ((platform.isSybase() || platform.isSQLAnywhere()) && platform.supportsAutoCommit()) {
            throw new TestWarningException("Sybase requires supportAutoCommit()==false");
        }
    }
}

