/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneListIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.node.DefaultProblem;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.NodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class AbstractNodeModel
extends AbstractModel
implements NodeModel {
    private volatile Node parent;
    private volatile String comment;
    public static final String COMMENT_PROPERTY = "comment";
    private volatile boolean dirty;
    private volatile boolean dirtyBranch;
    private List problems;
    private static final Object[] EMPTY_PROBLEM_MESSAGE_ARGUMENTS = new Object[0];
    private List branchProblems;
    private static final Map transientAspectNameSets = new Hashtable();
    private static final Map insignificantAspectNameSets = new Hashtable();

    protected AbstractNodeModel() {
    }

    protected AbstractNodeModel(Node parent) {
        this();
        this.initialize(parent);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.comment = "";
        this.dirty = true;
        this.dirtyBranch = true;
        this.problems = new Vector();
        this.branchProblems = new Vector();
    }

    protected void initialize(Node parentNode) {
        this.checkParent(parentNode);
        this.parent = parentNode;
    }

    @Override
    protected ChangeSupport buildDefaultChangeSupport() {
        return new ChangeSupport(this){
            private static final long serialVersionUID = 1L;

            @Override
            protected ChangeNotifier notifier() {
                return AbstractNodeModel.this.getChangeNotifier();
            }

            @Override
            protected ChangeSupport buildChildChangeSupport() {
                return AbstractNodeModel.this.buildChildChangeSupport();
            }

            @Override
            protected void sourceChanged(String aspectName) {
                super.sourceChanged(aspectName);
                AbstractNodeModel.this.aspectChanged(aspectName);
            }
        };
    }

    protected ChangeSupport buildChildChangeSupport() {
        return new ChangeSupport(this){
            private static final long serialVersionUID = 1L;

            @Override
            protected ChangeNotifier notifier() {
                return AbstractNodeModel.this.getChangeNotifier();
            }

            @Override
            protected ChangeSupport buildChildChangeSupport() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final Node getParent() {
        return this.parent;
    }

    @Override
    public final void setParent(Node parentNode) {
        this.checkParent(parentNode);
        this.parent = parentNode;
    }

    protected void checkParent(Node parentNode) {
        if (parentNode == null) {
            throw new IllegalArgumentException("The parent node cannot be null");
        }
    }

    @Override
    public final Iterator children() {
        ArrayList children = new ArrayList();
        this.addChildrenTo(children);
        return children.iterator();
    }

    protected void addChildrenTo(List list) {
    }

    @Override
    public final void setChildBackpointers() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.setParent(this);
            child.setChildBackpointers();
        }
    }

    @Override
    public final boolean isDescendantOf(Node node) {
        return this == node || this.parentIsDescendantOf(node);
    }

    protected boolean parentIsDescendantOf(Node node) {
        return this.parent != null && this.parent.isDescendantOf(node);
    }

    public final Iterator branchReferences() {
        ArrayList branchReferences = new ArrayList(1000);
        this.addBranchReferencesTo(branchReferences);
        return branchReferences.iterator();
    }

    @Override
    public final void addBranchReferencesTo(Collection branchReferences) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.addBranchReferencesTo(branchReferences);
        }
    }

    public final Iterator allNodes() {
        ArrayList nodes = new ArrayList(1000);
        this.addAllNodesTo(nodes);
        return nodes.iterator();
    }

    @Override
    public final void addAllNodesTo(Collection nodes) {
        nodes.add(this);
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.addAllNodesTo(nodes);
        }
    }

    @Override
    public void nodeRemoved(Node node) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.nodeRemoved(node);
        }
    }

    protected boolean nodeIsDescendantOf(Node node1, Node node2) {
        return node1 != null && node1.isDescendantOf(node2);
    }

    @Override
    public void nodeRenamed(Node node) {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.nodeRenamed(node);
        }
    }

    public final String getComment() {
        return this.comment;
    }

    public final void setComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.firePropertyChanged(COMMENT_PROPERTY, old, comment);
    }

    @Override
    public ChangeNotifier getChangeNotifier() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.getChangeNotifier();
    }

    @Override
    public void setChangeNotifier(ChangeNotifier changeNotifier) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setChangeNotifier(ChangeNotifier).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setChangeNotifier(ChangeNotifier).");
    }

    protected void aspectChanged(String aspectName) {
        if (this.aspectIsPersistent(aspectName)) {
            this.markDirty();
        }
        if (this.aspectIsSignificant(aspectName)) {
            this.getValidator().validate();
        }
    }

    @Override
    public Node.Validator getValidator() {
        if (this.parent == null) {
            throw new IllegalStateException("This node should not be firing change events during its construction.");
        }
        return this.parent.getValidator();
    }

    @Override
    public void setValidator(Node.Validator validator) {
        if (this.parent == null) {
            throw new IllegalStateException("This root node should implement #setValidator(Node.Validator).");
        }
        throw new UnsupportedOperationException("Only root nodes implement #setValidator(Node.Validator).");
    }

    public final boolean isDirty() {
        return this.dirty;
    }

    @Override
    public final boolean isDirtyBranch() {
        return this.dirtyBranch;
    }

    public final boolean isClean() {
        return !this.dirty;
    }

    public final boolean isCleanBranch() {
        return !this.dirtyBranch;
    }

    private void setIsDirtyBranch(boolean dirtyBranch) {
        boolean old = this.dirtyBranch;
        this.dirtyBranch = dirtyBranch;
        this.firePropertyChanged("dirtyBranch", old, dirtyBranch);
    }

    private void markDirty() {
        this.dirty = true;
        this.markBranchDirty();
    }

    @Override
    public void markBranchDirty() {
        if (this.dirtyBranch) {
            return;
        }
        this.setIsDirtyBranch(true);
        this.markParentBranchDirty();
    }

    protected void markParentBranchDirty() {
        if (this.parent != null) {
            this.parent.markBranchDirty();
        }
    }

    @Override
    public final void markEntireBranchDirty() {
        this.markDirty();
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.markEntireBranchDirty();
        }
    }

    public final void markEntireBranchClean() {
        this.cascadeMarkEntireBranchClean();
        this.markParentBranchCleanIfPossible();
    }

    protected void markParentBranchCleanIfPossible() {
        if (this.parent != null) {
            this.parent.markBranchCleanIfPossible();
        }
    }

    @Override
    public final void cascadeMarkEntireBranchClean() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.cascadeMarkEntireBranchClean();
        }
        this.dirty = false;
        this.setIsDirtyBranch(false);
    }

    @Override
    public final void markBranchCleanIfPossible() {
        if (this.dirty) {
            return;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            if (!child.isDirtyBranch()) continue;
            return;
        }
        this.setIsDirtyBranch(false);
        this.markParentBranchCleanIfPossible();
    }

    private boolean aspectIsPersistent(String aspectName) {
        return !this.aspectIsTransient(aspectName);
    }

    private boolean aspectIsTransient(String aspectName) {
        return this.transientAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set transientAspectNames() {
        Map map = transientAspectNameSets;
        synchronized (map) {
            HashSet transientAspectNames = (HashSet)transientAspectNameSets.get(this.getClass());
            if (transientAspectNames == null) {
                transientAspectNames = new HashSet();
                this.addTransientAspectNamesTo(transientAspectNames);
                transientAspectNameSets.put(this.getClass(), transientAspectNames);
            }
            return transientAspectNames;
        }
    }

    protected void addTransientAspectNamesTo(Set transientAspectNames) {
        transientAspectNames.add("dirtyBranch");
        transientAspectNames.add("branchProblems");
        transientAspectNames.add("hasBranchProblems");
    }

    public final Iterator allDirtyNodes() {
        return new FilteringIterator(this.allNodes()){

            @Override
            protected boolean accept(Object o) {
                return o instanceof AbstractNodeModel && ((AbstractNodeModel)o).isDirty();
            }
        };
    }

    public final Iterator problems() {
        return new CloneIterator(this.problems);
    }

    public final int problemsSize() {
        return this.problems.size();
    }

    public final boolean hasProblems() {
        return !this.problems.isEmpty();
    }

    @Override
    public final ListIterator branchProblems() {
        return new CloneListIterator(this.branchProblems);
    }

    @Override
    public final int branchProblemsSize() {
        return this.branchProblems.size();
    }

    @Override
    public final boolean hasBranchProblems() {
        return !this.branchProblems.isEmpty();
    }

    @Override
    public final boolean containsBranchProblem(Problem problem) {
        return this.branchProblems.contains(problem);
    }

    protected final Problem buildProblem(String messageKey, Object[] messageArguments) {
        return new DefaultProblem(this, messageKey, messageArguments);
    }

    protected final Problem buildProblem(String messageKey) {
        return this.buildProblem(messageKey, EMPTY_PROBLEM_MESSAGE_ARGUMENTS);
    }

    protected final Problem buildProblem(String messageKey, Object messageArgument) {
        return this.buildProblem(messageKey, new Object[]{messageArgument});
    }

    protected final Problem buildProblem(String messageKey, Object messageArgument1, Object messageArgument2) {
        return this.buildProblem(messageKey, new Object[]{messageArgument1, messageArgument2});
    }

    protected final Problem buildProblem(String messageKey, Object messageArgument1, Object messageArgument2, Object messageArgument3) {
        return this.buildProblem(messageKey, new Object[]{messageArgument1, messageArgument2, messageArgument3});
    }

    @Override
    public void validateBranch() {
        if (this.validateBranchInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    protected void rebuildParentBranchProblems() {
        if (this.parent != null) {
            this.parent.rebuildBranchProblems();
        }
    }

    @Override
    public boolean validateBranchInternal() {
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.validateBranchInternal();
        }
        this.problems.clear();
        this.addProblemsTo(this.problems);
        return this.checkBranchProblems();
    }

    protected void addProblemsTo(List currentProblems) {
    }

    private boolean checkBranchProblems() {
        Vector oldBranchProblems = new Vector(this.branchProblems);
        int oldSize = this.branchProblems.size();
        this.branchProblems.clear();
        this.branchProblems.addAll(this.problems);
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.addBranchProblemsTo(this.branchProblems);
        }
        int newSize = this.branchProblems.size();
        if (oldSize == 0 && newSize != 0) {
            this.firePropertyChanged("hasBranchProblems", false, true);
        } else if (oldSize != 0 && newSize == 0) {
            this.firePropertyChanged("hasBranchProblems", true, false);
        }
        if (oldBranchProblems.equals(this.branchProblems)) {
            return false;
        }
        this.fireListChanged("branchProblems");
        return true;
    }

    @Override
    public final void addBranchProblemsTo(List list) {
        list.addAll(this.branchProblems);
    }

    @Override
    public final void rebuildBranchProblems() {
        if (!this.checkBranchProblems()) {
            throw new IllegalStateException("we should not get here unless our \"branch\" problems have changed");
        }
        this.rebuildParentBranchProblems();
    }

    @Override
    public final void clearAllBranchProblems() {
        if (this.clearAllBranchProblemsInternal()) {
            this.rebuildParentBranchProblems();
        }
    }

    @Override
    public final boolean clearAllBranchProblemsInternal() {
        if (this.branchProblems.isEmpty()) {
            return false;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            Node child = (Node)stream.next();
            child.clearAllBranchProblemsInternal();
        }
        this.problems.clear();
        this.branchProblems.clear();
        this.firePropertyChanged("hasBranchProblems", true, false);
        this.fireListChanged("branchProblems");
        return true;
    }

    private boolean aspectIsSignificant(String aspectName) {
        return !this.aspectIsInsignificant(aspectName);
    }

    private boolean aspectIsInsignificant(String aspectName) {
        return this.insignificantAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set insignificantAspectNames() {
        Map map = insignificantAspectNameSets;
        synchronized (map) {
            HashSet insignificantAspectNames = (HashSet)insignificantAspectNameSets.get(this.getClass());
            if (insignificantAspectNames == null) {
                insignificantAspectNames = new HashSet();
                this.addInsignificantAspectNamesTo(insignificantAspectNames);
                insignificantAspectNameSets.put(this.getClass(), insignificantAspectNames);
            }
            return insignificantAspectNames;
        }
    }

    protected void addInsignificantAspectNamesTo(Set insignificantAspectNames) {
        insignificantAspectNames.add(COMMENT_PROPERTY);
        insignificantAspectNames.add("dirtyBranch");
        insignificantAspectNames.add("branchProblems");
        insignificantAspectNames.add("hasBranchProblems");
    }

    public int compareTo(Object o) {
        return DEFAULT_COMPARATOR.compare(this, o);
    }

    @Override
    public final String toString() {
        return super.toString();
    }
}

