/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.persistence.tools.workbench.framework.app.AccessibleNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.NavigatorSelectionModel;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.help.HelpManager;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.uitools.Displayable;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TreeModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.DisplayableTreeCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.SimpleStack;
import org.eclipse.persistence.tools.workbench.utility.Stack;
import org.eclipse.persistence.tools.workbench.utility.iterators.EnumerationIterator;

final class NavigatorView {
    private ApplicationContext context;
    private ValueModel selectionMenuDescriptionHolder;
    private PropertyChangeListener selectionMenuDescriptionListener;
    private JPopupMenu selectionPopupMenu;
    private SelectionModel selectionModel;
    private TreeModel treeModel;
    private TreeModelListener treeModelListener;
    private int rootNodeChildrenSize;
    private JPanel component;
    private JTree tree;

    NavigatorView(ApplicationContext context, ValueModel selectionMenuDescriptionHolder) {
        this.context = context;
        this.selectionPopupMenu = new JPopupMenu();
        this.selectionMenuDescriptionHolder = selectionMenuDescriptionHolder;
        this.selectionMenuDescriptionListener = this.buildSelectionMenuDescriptionListener();
        this.selectionMenuDescriptionHolder.addPropertyChangeListener("value", this.selectionMenuDescriptionListener);
        this.treeModel = this.buildTreeModel();
        this.treeModelListener = this.buildTreeModelListener();
        this.treeModel.addTreeModelListener(this.treeModelListener);
        this.rootNodeChildrenSize = this.rootNode().getChildrenModel().size();
        this.component = this.buildComponent();
    }

    private PropertyChangeListener buildSelectionMenuDescriptionListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                NavigatorView.this.selectionMenuDescriptionChanged();
            }
        };
    }

    private JPanel buildComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
        panel.setMinimumSize(new Dimension(0, 0));
        JLabel label = new JLabel(this.resourceRepository().getString("NAVIGATOR_LABEL"));
        label.setDisplayedMnemonic(this.resourceRepository().getMnemonic("NAVIGATOR_LABEL"));
        label.setIcon(this.resourceRepository().getIcon("navigator"));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, panel.getBackground().darker()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        panel.add((Component)label, "First");
        this.tree = this.buildTree();
        this.selectionModel = new SelectionModel(this.tree);
        this.tree.setSelectionModel(this.selectionModel);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        scrollPane.setBorder(null);
        panel.add((Component)scrollPane, "Center");
        label.setLabelFor(this.tree);
        return panel;
    }

    private JTree buildTree() {
        NavigatorTree result = new NavigatorTree(this.treeModel);
        result.setShowsRootHandles(true);
        result.setRootVisible(false);
        result.setCellRenderer(this.buildTreeCellRenderer());
        result.setRowHeight(0);
        result.addMouseListener(this.buildMouseListener());
        result.addKeyListener(this.buildKeyListener());
        return result;
    }

    private TreeCellRenderer buildTreeCellRenderer() {
        return new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree t, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                return new ApplicationNodeTreeCellRenderer().getTreeCellRendererComponent(t, value, selected, expanded, leaf, row, hasFocus);
            }
        };
    }

    private MouseListener buildMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handleMouseEvent(e);
            }

            private void handleMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    NavigatorView.this.displayPopupMenu((JTree)e.getSource(), e.getX(), e.getY());
                }
            }
        };
    }

    private KeyListener buildKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                NavigatorView.this.keyPressed(e);
            }
        };
    }

    private TreeModel buildTreeModel() {
        return new TreeModelAdapter(this.rootNode());
    }

    private TreeModelListener buildTreeModelListener() {
        return new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                NavigatorView.this.treeChanged();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                NavigatorView.this.treeChanged();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                NavigatorView.this.treeChanged();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                NavigatorView.this.treeChanged();
            }
        };
    }

    void addTreeSelectionListener(TreeSelectionListener listener) {
        this.selectionModel.addTreeSelectionListener(listener);
    }

    void removeTreeSelectionListener(TreeSelectionListener listener) {
        this.selectionModel.removeTreeSelectionListener(listener);
    }

    void selectionMenuDescriptionChanged() {
        this.selectionPopupMenu.removeAll();
        GroupContainerDescription selectionMenuDescription = (GroupContainerDescription)this.selectionMenuDescriptionHolder.getValue();
        ListIterator stream = selectionMenuDescription.components();
        while (stream.hasNext()) {
            this.selectionPopupMenu.add((Component)stream.next());
        }
    }

    void displayPopupMenu(JTree t, int x, int y) {
        TreePath path = t.getPathForLocation(x, y);
        if (path == null) {
            return;
        }
        Object[] selectedPaths = t.getSelectionPaths();
        if (selectedPaths == null || !CollectionTools.contains((Object[])selectedPaths, (Object)path)) {
            t.setSelectionPath(path);
        }
        if (this.selectionPopupMenu.getComponentCount() > 0) {
            this.selectionPopupMenu.show(t, x, y);
        }
    }

    void keyPressed(KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 112: {
                this.displayHelp();
                e.consume();
                break;
            }
            case 121: {
                if (!e.isShiftDown()) break;
                this.displayPopupMenu((JTree)e.getSource());
                e.consume();
                break;
            }
        }
    }

    private void displayHelp() {
        ApplicationNode[] nodes = this.selectionModel.getSelectedNodes();
        if (nodes.length != 1) {
            return;
        }
        ApplicationNode node = nodes[0];
        this.helpManager().showTopic(node.helpTopicID());
    }

    private void displayPopupMenu(JTree t) {
        ApplicationNode[] nodes = this.selectionModel.getSelectedNodes();
        if (nodes.length != 1) {
            return;
        }
        ApplicationNode node = nodes[0];
        Rectangle rec = t.getPathBounds(new TreePath(node.path()));
        if (this.selectionPopupMenu.getComponentCount() > 0) {
            this.selectionPopupMenu.show(t, (int)rec.getCenterX(), (int)rec.getCenterY());
        }
    }

    void treeChanged() {
        int oldSize = this.rootNodeChildrenSize;
        int newSize = this.rootNode().getChildrenModel().size();
        if (oldSize == 0 && newSize != 0) {
            this.selectionModel.setSelectedNode((ApplicationNode)this.rootNode().getChildrenModel().getItem(0));
        }
        this.rootNodeChildrenSize = newSize;
    }

    void saveTreeExpansionState(Preferences windowsPreferences) {
        this.selectionModel.saveTreeExpansionState(windowsPreferences);
    }

    void restoreTreeExpansionState(Preferences windowsPreferences) {
        this.selectionModel.restoreTreeExpansionState(windowsPreferences);
    }

    void close() {
        this.treeModel.removeTreeModelListener(this.treeModelListener);
        this.selectionMenuDescriptionHolder.removePropertyChangeListener("value", this.selectionMenuDescriptionListener);
        this.tree.setModel(null);
    }

    Component getComponent() {
        return this.component;
    }

    NavigatorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getResourceRepository();
    }

    private TreeNodeValueModel rootNode() {
        return this.context.getNodeManager().getRootNode();
    }

    private HelpManager helpManager() {
        return this.context.getHelpManager();
    }

    private static class ApplicationNodeTreeCellRenderer
    extends DisplayableTreeCellRenderer {
        private ApplicationNodeTreeCellRenderer() {
        }

        @Override
        protected String buildAccessibleName(Object value) {
            return ((AccessibleNode)value).accessibleName();
        }

        @Override
        protected String buildText(Object value) {
            String text = super.buildText(value);
            if (text == null) {
                return text;
            }
            return ((ApplicationNode)value).isDirty() ? '*' + text : text;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(d.width, d.height + 1);
        }
    }

    private static class SelectionModel
    extends DefaultTreeSelectionModel
    implements NavigatorSelectionModel {
        private JTree tree;
        private Stack expansionStates;
        private static final ApplicationNode[] EMPTY_SELECTED_NODES = new ApplicationNode[0];

        public SelectionModel(JTree tree) {
            this.tree = tree;
            this.expansionStates = new SimpleStack();
        }

        @Override
        public ApplicationNode[] getSelectedNodes() {
            int len;
            TreePath[] paths = this.getSelectionPaths();
            int n = len = paths == null ? 0 : paths.length;
            if (len == 0) {
                return EMPTY_SELECTED_NODES;
            }
            ApplicationNode[] nodes = new ApplicationNode[len];
            int i = len;
            while (i-- > 0) {
                nodes[i] = (ApplicationNode)paths[i].getLastPathComponent();
            }
            return nodes;
        }

        @Override
        public ApplicationNode[] getSelectedProjectNodes() {
            ApplicationNode[] selectedNodes = this.getSelectedNodes();
            HashSet<ApplicationNode> selectedRootNodes = new HashSet<ApplicationNode>(selectedNodes.length);
            int i = selectedNodes.length;
            while (i-- > 0) {
                selectedRootNodes.add(selectedNodes[i].getProjectRoot());
            }
            return selectedRootNodes.toArray(new ApplicationNode[selectedRootNodes.size()]);
        }

        @Override
        public void pushExpansionState() {
            this.expansionStates.push((Object)this.currentExpansionState());
        }

        @Override
        public void popAndRestoreExpansionState() {
            Collection expandedPaths = (Collection)this.expansionStates.pop();
            Iterator stream = expandedPaths.iterator();
            while (stream.hasNext()) {
                this.tree.expandPath((TreePath)stream.next());
            }
        }

        @Override
        public void popAndRestoreExpansionState(ApplicationNode oldNode, ApplicationNode morphedNode) {
            Collection expandedPaths = (Collection)this.expansionStates.pop();
            for (TreePath path : expandedPaths) {
                if (path.getLastPathComponent() == oldNode) {
                    path = new TreePath(morphedNode.path());
                }
                this.tree.expandPath(path);
            }
        }

        @Override
        public void setSelectedNode(ApplicationNode node) {
            TreePath path = new TreePath(node.path());
            this.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            super.setSelectionPaths(paths);
            for (int i = 0; i < paths.length; ++i) {
                this.tree.scrollPathToVisible(paths[i]);
            }
        }

        @Override
        public void expandNode(ApplicationNode node) {
            this.tree.expandPath(new TreePath(node.path()));
        }

        void saveTreeExpansionState(Preferences windowsPreferences) {
        }

        void restoreTreeExpansionState(Preferences windowsPreferences) {
        }

        private Collection currentExpansionState() {
            Enumeration<TreePath> stream = this.tree.getExpandedDescendants(new TreePath(this.tree.getModel().getRoot()));
            if (stream == null) {
                return Collections.EMPTY_LIST;
            }
            return CollectionTools.list((Iterator)new EnumerationIterator(stream));
        }
    }

    private class NavigatorTree
    extends JTree {
        public NavigatorTree(TreeModel model) {
            super(model);
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return value == null ? "" : ((Displayable)value).displayString();
        }
    }
}

