/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.indirection.jdk8;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

public class IndirectList<E>
extends org.eclipse.persistence.indirection.IndirectList<E> {
    public IndirectList() {
    }

    public IndirectList(int initialCapacity) {
        super(initialCapacity);
    }

    public IndirectList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public IndirectList(Collection<? extends E> vector) {
        super(vector);
    }

    @Override
    public ListIterator<E> listIterator(final int index) {
        return new ListIterator<E>(){
            ListIterator<E> delegateIterator;
            E currentObject;
            {
                this.delegateIterator = IndirectList.this.getDelegate().listIterator(index);
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            @Override
            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            @Override
            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            @Override
            public E next() {
                this.currentObject = this.delegateIterator.next();
                return this.currentObject;
            }

            @Override
            public E previous() {
                this.currentObject = this.delegateIterator.previous();
                return this.currentObject;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, this.delegateIterator.nextIndex());
            }

            @Override
            public void set(E object) {
                this.delegateIterator.set(object);
                Integer index2 = this.delegateIterator.previousIndex();
                IndirectList.this.raiseRemoveChangeEvent(this.currentObject, index2, true);
                IndirectList.this.raiseAddChangeEvent(object, index2, true);
            }

            @Override
            public void add(E object) {
                this.delegateIterator.add(object);
                IndirectList.this.raiseAddChangeEvent(object, this.delegateIterator.previousIndex());
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                this.delegateIterator.forEachRemaining(action);
            }
        };
    }

    @Override
    public void sort(Comparator<? super E> c) {
        this.getDelegate().sort(c);
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.getDelegate().spliterator();
    }

    @Override
    public synchronized void replaceAll(UnaryOperator<E> operator) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            Vector del = this.getDelegate();
            for (int i = 0; i < del.size(); ++i) {
                this.set(i, operator.apply(del.get(i)));
            }
        } else {
            this.getDelegate().replaceAll(operator);
        }
    }

    @Override
    public synchronized boolean removeIf(Predicate<? super E> filter) {
        if (this.hasBeenRegistered() || this.hasTrackedPropertyChangeListener()) {
            boolean hasChanged = false;
            Iterator objects = this.iterator();
            while (objects.hasNext()) {
                if (!filter.test(objects.next())) continue;
                objects.remove();
                hasChanged |= true;
            }
            return hasChanged;
        }
        return this.getDelegate().removeIf(filter);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.getDelegate().forEach(action);
    }

    @Override
    public Stream<E> parallelStream() {
        return this.getDelegate().parallelStream();
    }

    @Override
    public Stream<E> stream() {
        return this.getDelegate().stream();
    }
}

