/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class UpdateObjectInvalidationTest
extends ConfigurableCacheSyncDistributedTest {
    protected Employee employee;

    public UpdateObjectInvalidationTest() {
        this.setDescription("Ensure a remote object is invalidated when its descriptor is set to INVALIDATE_CHANGED_OBJECTS");
        this.cacheSyncConfigValues.put(Employee.class, new Integer(2));
    }

    @Override
    public void setup() {
        super.setup();
        this.employee = new Employee();
        this.employee.setFirstName("George");
        this.employee.setLastName("Alpha");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.employee);
        uow.commit();
        ExpressionBuilder employees = new ExpressionBuilder();
        Expression expression = employees.get("firstName").equal((Object)this.employee.getFirstName());
        expression = expression.and(employees.get("lastName").equal((Object)this.employee.getLastName()));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().firstElement();
        Object result = server.getDistributedSession().readObject(Employee.class, expression);
        UpdateObjectInvalidationTest.assertNotNull((Object)result);
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee employeeClone = (Employee)uow.registerObject((Object)this.employee);
        employeeClone.setLastName("Beta");
        uow.commit();
        uow = this.getSession().acquireUnitOfWork();
        employeeClone = (Employee)uow.registerObject((Object)this.employee);
        employeeClone.setLastName("Gamma");
        uow.commit();
    }

    public void verify() {
        if (this.isObjectValidOnDistributedServer(this.employee)) {
            throw new TestErrorException("Employee should have been invalidated in the distributed cache, descriptor was set to: INVALIDATE_CHANGED_OBJECTS");
        }
    }
}

