/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Customer;
import org.eclipse.persistence.testing.tests.events.EventHookTestCase;

public class ObjectChangeSetEventTest
extends EventHookTestCase {
    public Customer customer;

    @Override
    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.customer = Customer.example1();
        uow.registerObject((Object)this.customer);
        uow.commit();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Customer cloneCustomer = (Customer)uow.readObject((Object)this.customer);
        cloneCustomer.preWrite = true;
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Customer originalCustomer = (Customer)this.getSession().readObject((Object)this.customer);
        if (!originalCustomer.name.equals("PreWrite")) {
            throw new TestErrorException("Failed to cause update when attribute was changed in the pre-write event");
        }
    }
}

