/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TransactionalTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;

public class BatchWritingTest
extends TransactionalTestCase {
    protected static int NUM_INSERTS = 200;

    public BatchWritingTest() {
        this.setDescription("Tests a large number of inserts using Batch Writing");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        for (int i = 0; i < NUM_INSERTS; ++i) {
            Address address = new Address();
            address.setCity("city" + i);
            address.setProvince("province" + i);
            uow.registerObject((Object)address);
        }
        uow.commit();
        ((DatabaseAccessor)uow.getParent().getAccessor()).getActiveBatchWritingMechanism(this.getAbstractSession()).executeBatchedStatements(uow.getParent());
    }
}

