/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.helper;

import java.sql.Timestamp;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class TimestampFromLongTest
extends AutoVerifyTestCase {
    Long currentTime;
    Timestamp optimizedTime;
    boolean optimizedDatesState;

    public static void main(String[] args) {
        TimestampFromLongTest test = new TimestampFromLongTest();
        test.setup();
        test.test();
        test.verify();
        test.reset();
    }

    public TimestampFromLongTest() {
        this.setDescription("Test of Helper.timestampFromLong(Long longObject)");
    }

    public void setup() {
        this.currentTime = new Long(System.currentTimeMillis());
        this.optimizedDatesState = Helper.shouldOptimizeDates();
    }

    public void test() {
        Helper.setShouldOptimizeDates((boolean)true);
        this.optimizedTime = Helper.timestampFromLong((Long)this.currentTime);
    }

    public void verify() {
        String testTime = new Timestamp(this.currentTime).toString();
        if (!testTime.equals(this.optimizedTime.toString())) {
            throw new TestErrorException("Failed to convert Long to java.sql.Timestamp when shouldOptimizedDates is on");
        }
    }

    public void reset() {
        Helper.setShouldOptimizeDates((boolean)this.optimizedDatesState);
    }
}

