/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.optimization;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.legacy.Shipment;

public class OneToManyBatchReadingCustomSelectionQueryTest
extends TestCase {
    BatchFetchType batchType;
    public Vector shipments;

    public OneToManyBatchReadingCustomSelectionQueryTest(BatchFetchType batchType) {
        this.setDescription("Tests a one to many mapping using a custom selction query to perform batch reading and a join ");
        this.batchType = batchType;
        this.setName(this.getName() + batchType);
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        if (this.batchType == BatchFetchType.IN && !this.getSession().getPlatform().isOracle()) {
            this.throwWarning("Nested arrays not supported on this database");
        }
    }

    public void test() {
        ReadAllQuery q = new ReadAllQuery();
        q.setBatchFetchType(this.batchType);
        q.setReferenceClass(Shipment.class);
        q.addBatchReadAttribute("orders");
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.shipments = (Vector)uow.executeQuery((DatabaseQuery)q);
    }

    public void verify() {
        Enumeration enumtr = this.shipments.elements();
        while (enumtr.hasMoreElements()) {
            Shipment shipment = (Shipment)enumtr.nextElement();
            if (shipment.orders.size() != 0) continue;
            throw new TestErrorException("Test failed. Batched objects were not read");
        }
    }
}

