/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.remote.RemoteUnitOfWork;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class UnitOfWorkComplexRefreshTest
extends AutoVerifyTestCase {
    protected Employee dbEmployee1;
    protected Employee dbEmployee2;
    protected UnitOfWork uow1;
    protected UnitOfWork uow2;
    protected Writer oldLog;
    protected int oldLogLevel;
    protected StringWriter tempWriter;
    SessionEventListener listener;

    public UnitOfWorkComplexRefreshTest() {
        this.setDescription("Test that a refreshed object in unit of work does not generate sql on commit.");
    }

    public void setup() {
        if (this.getSession().isClientSession()) {
            this.listener = this.checkTransactionIsolation();
        }
        this.getAbstractSession().beginTransaction();
        this.uow1 = this.getSession().acquireUnitOfWork();
        this.uow2 = this.getSession().acquireUnitOfWork();
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Charles");
        this.dbEmployee1 = (Employee)this.uow1.readObject(Employee.class, exp);
        this.dbEmployee2 = (Employee)this.uow2.readObject(Employee.class, exp);
        this.dbEmployee1.getAddress().setCity("Bobstown");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.listener != null) {
            this.getAbstractSession().getParent().getEventManager().removeListener(this.listener);
            this.listener = null;
        }
    }

    public void switchLog(Session aSession) {
        if (aSession instanceof RemoteUnitOfWork) {
            aSession = RemoteModel.getServerSession();
        }
        this.oldLog = aSession.getLog();
        this.oldLogLevel = aSession.getLogLevel();
        aSession.setLogLevel(3);
        this.tempWriter = new StringWriter();
        aSession.setLog((Writer)this.tempWriter);
    }

    public void switchLoggingBack(Session aSession) {
        if (aSession.isRemoteUnitOfWork()) {
            aSession = RemoteModel.getServerSession();
        }
        aSession.setLogLevel(this.oldLogLevel);
        aSession.setLog(this.oldLog);
    }

    public void test() {
        this.dbEmployee2.getAddress().setCity("Yousersville");
        this.uow2.commit();
        this.uow1.refreshObject((Object)this.dbEmployee1);
        this.switchLog((Session)this.uow1);
        this.uow1.commit();
        this.switchLoggingBack((Session)this.uow1);
    }

    public void verify() {
        if (this.dbEmployee1.getAddress().getCity().equals("Bobstown")) {
            throw new TestErrorException("The object in the unit of work was properly refreshed.");
        }
        if (this.tempWriter.toString().indexOf("UPDATE ADDRESS SET CITY = 'Yousersville'") != -1) {
            throw new TestErrorException("The second commit updated the database, but should not have, '" + this.tempWriter.toString() + "'");
        }
    }
}

