/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import java.io.File;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.factories.XMLProjectWriter;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.workbenchintegration.Employee;

public class QueryShouldMaintainCacheTest
extends AutoVerifyTestCase {
    protected Project project = null;
    public static final String FILENAME = "EmployeeProjectForQueryShouldMaintainCacheTest.xml";

    public QueryShouldMaintainCacheTest() {
        this.setDescription("Ensure should maintain cache settings for descriptors are properly written out.");
    }

    public void setup() {
        this.project = new EmployeeProject();
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(org.eclipse.persistence.testing.models.employee.domain.Employee.class);
        descriptor.disableCacheHits();
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.maintainCache();
        descriptor.getQueryManager().addQuery("TrueQuery", (DatabaseQuery)query);
        query = new ReadObjectQuery(Employee.class);
        query.dontMaintainCache();
        descriptor.getQueryManager().addQuery("FalseQuery", (DatabaseQuery)query);
    }

    public void test() {
        XMLProjectWriter.write((String)FILENAME, (Project)this.project);
        this.project = XMLProjectReader.read((String)FILENAME, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
    }

    public void verify() {
        ClassDescriptor descriptor = (ClassDescriptor)this.project.getDescriptors().get(org.eclipse.persistence.testing.models.employee.domain.Employee.class);
        ReadObjectQuery query = (ReadObjectQuery)descriptor.getQueryManager().getQuery("TrueQuery");
        if (!query.shouldMaintainCache() || !query.shouldMaintainCache()) {
            throw new TestErrorException("Project read from XML should be set to maintainCache, but is not.");
        }
        query = (ReadObjectQuery)descriptor.getQueryManager().getQuery("FalseQuery");
        if (query.shouldMaintainCache() || query.shouldMaintainCache()) {
            throw new TestErrorException("Project read from XML should be set not to maintainCache, but it does.");
        }
    }

    public void reset() {
        File file = new File(FILENAME);
        file.delete();
    }
}

