/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.uitools;

import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;

public class TriStateBooleanCellRendererAdapter
extends AbstractCellRendererAdapter {
    private final StringRepository stringRepository;

    public TriStateBooleanCellRendererAdapter(StringRepository stringRepository) {
        this.stringRepository = stringRepository;
    }

    @Override
    public String buildText(Object value) {
        if (TriStateBoolean.TRUE.equals(value)) {
            return this.trueString();
        }
        if (TriStateBoolean.FALSE.equals(value)) {
            return this.falseString();
        }
        if (TriStateBoolean.UNDEFINED.equals(value)) {
            return this.undefinedString();
        }
        return null;
    }

    protected String trueString() {
        return this.stringRepository.getString(this.trueResourceKey());
    }

    protected String trueResourceKey() {
        return "TRI_STATE_BOOLEAN_TRUE";
    }

    protected String falseString() {
        return this.stringRepository.getString(this.falseResourceKey());
    }

    protected String falseResourceKey() {
        return "TRI_STATE_BOOLEAN_FALSE";
    }

    protected String undefinedString() {
        return this.stringRepository.getString(this.undefinedResourceKey());
    }

    protected String undefinedResourceKey() {
        return "TRI_STATE_BOOLEAN_UNDEFINED";
    }
}

