/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.OpenException;
import org.eclipse.persistence.tools.workbench.framework.Plugin;
import org.eclipse.persistence.tools.workbench.framework.UnsupportedFileException;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuItemDescription;
import org.eclipse.persistence.tools.workbench.framework.app.PreferencesNode;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.context.ShellWorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.EmptyPropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsio.FileNotFoundListener;
import org.eclipse.persistence.tools.workbench.mappingsio.LegacyProjectReadCallback;
import org.eclipse.persistence.tools.workbench.mappingsio.ProjectIOManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AddOrRefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomapAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.CreateNewClassAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportModelJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ExportSpecificDescriptorModelJavaSourceAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.LegacyProjectMigrationDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ManageNonDescriptorClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginIconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPluginResourceBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.NewProjectAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.OracleHelpAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ProblemsBundle;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RefreshClassesAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemoveAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.preferences.MappingsPreferencesNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.ExportTableCreatorJavaSourceAction;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.Command;
import org.eclipse.persistence.tools.workbench.utility.Stack;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedObject;
import org.eclipse.persistence.tools.workbench.utility.SynchronizedStack;
import org.eclipse.persistence.tools.workbench.utility.TriStateBoolean;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MappingsPlugin
implements Plugin {
    private ApplicationContext mwApplicationContext;
    private SynchronizedObject synchronizedIOManager;
    private Map propertiesPageCache;
    SynchronizedStack propertiesPageBuilderStack;
    private static final String MAPPINGS_PREFERENCES_NODE = "mappings";
    public static final String REMOVE_EJB_2X_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE = "persistence type remove ejb2x info";
    public static final String REMOVE_EJB_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE = "persistence type remove ejb info";
    public static final String CHANGE_QUERY_TYPE_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE = "query change query type";
    public static final String CHANGE_QUERY_FORMAT_DO_NOT_SHOW_THIS_AGAIN_PREFERENCE = "query change query format";
    public static final String EXPORT_LOCATION_PREFERENCE = "export location";
    private static final String[] PRE_BUILT_PROPERTIES_PAGES = new String[]{"org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.DatabasePropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackagePropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.AggregateDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.InterfaceDescriptorPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml.EisCompositeDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml.EisRootDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.xml.OXDescriptorTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.framework.ui.view.EmptyPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.AggregateMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.DirectToFieldMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.DirectToXmlTypePropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.ManyToManyMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.OneToManyMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.OneToOneMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalDirectCollectionMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalDirectMapMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.RelationalTransformationMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.VariableOneToOneMappingTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisCompositeCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OXCompositeCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisCompositeObjectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OXCompositeObjectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisOneToManyTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisOneToOneTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OxDirectCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisDirectCollectionMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OxDirectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisDirectMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.EisTransformationMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.xml.OXTransformationMappingPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.EisProjectTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.xml.OXProjectTabbedPropertiesPage", "org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.XmlSchemaRepositoryPanel"};

    MappingsPlugin(ApplicationContext context) {
        this.mwApplicationContext = this.wrap(context);
        this.startInitializeSynchronizedIOManager();
        this.initializePreferences();
        this.initializePropertiesPageBuilder();
    }

    private void startInitializeSynchronizedIOManager() {
        this.synchronizedIOManager = new SynchronizedObject();
        Thread t = new Thread(this.buildInitializeSynchronizedIOManagerRunnable(), "Initialize Mappings I/O Manager");
        t.setPriority(1);
        t.start();
    }

    private Runnable buildInitializeSynchronizedIOManagerRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                MappingsPlugin.this.initializeSynchronizedIOManager();
            }
        };
    }

    void initializeSynchronizedIOManager() {
        try {
            this.synchronizedIOManager.execute(this.buildInitializeIOManagerCommand());
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Command buildInitializeIOManagerCommand() {
        return new Command(){

            public void execute() {
                MappingsPlugin.this.initializeIOManager();
            }
        };
    }

    void initializeIOManager() {
        this.synchronizedIOManager.setValue((Object)new ProjectIOManager());
    }

    private void initializePreferences() {
        Preferences preferences = this.mwApplicationContext.getPreferences();
        String value = preferences.get(REMOVE_EJB_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, TriStateBoolean.UNDEFINED.toString());
        preferences.put(REMOVE_EJB_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, value);
        value = preferences.get(REMOVE_EJB_2X_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, TriStateBoolean.UNDEFINED.toString());
        preferences.put(REMOVE_EJB_2X_INFO_DO_NOT_THIS_SHOW_AGAIN_PREFERENCE, value);
    }

    private void initializePropertiesPageBuilder() {
        this.propertiesPageCache = new HashMap(PRE_BUILT_PROPERTIES_PAGES.length);
        this.propertiesPageBuilderStack = new SynchronizedStack();
        int i = PRE_BUILT_PROPERTIES_PAGES.length;
        while (i-- > 0) {
            this.propertiesPageBuilderStack.push((Object)this.classForName(PRE_BUILT_PROPERTIES_PAGES[i]));
        }
        new PropertiesPageBuilder().start();
    }

    private Class classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(className);
        }
    }

    @Override
    public JMenuItem[] buildNewMenuItems(WorkbenchContext context) {
        context = this.wrap(context);
        JMenuItem[] menuItems = new JMenuItem[]{new JMenuItem(this.buildNewProjectAction(context))};
        return menuItems;
    }

    @Override
    public ApplicationNode open(File file, WorkbenchContext context) throws UnsupportedFileException, OpenException {
        if (!FileTools.extension((File)file).equalsIgnoreCase(".mwp")) {
            throw new UnsupportedFileException();
        }
        MWProject project = null;
        Preferences preferences = context.getApplicationContext().getPreferences().node(MAPPINGS_PREFERENCES_NODE);
        context = this.wrap(context);
        LocalCallback callback = new LocalCallback(context);
        try {
            project = this.getIOManager().read(file, preferences, FileNotFoundListener.NULL_INSTANCE, (LegacyProjectReadCallback)callback);
        }
        catch (CancelException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new OpenException(t);
        }
        ApplicationNode projectNode = this.buildProjectNode(project, context);
        if (callback.saveLegacyProjectNow()) {
            if (!projectNode.saveAs(file, context)) {
                throw new CancelException();
            }
            JOptionPane.showMessageDialog(context.getCurrentWindow(), new LabelArea(context.getApplicationContext().getResourceRepository().getString("LEGACY_MIGRATION_COMPLETE.MESSAGE")), context.getApplicationContext().getResourceRepository().getString("LEGACY_MIGRATION_COMPLETE.TITLE"), 1);
        }
        return projectNode;
    }

    @Override
    public ComponentContainerDescription buildToolBarDescription(WorkbenchContext context) {
        context = this.wrap(context);
        ToolBarDescription tbd = new ToolBarDescription();
        ToolBarButtonGroupDescription tbbgd1 = new ToolBarButtonGroupDescription();
        tbbgd1.add(new ToolBarButtonDescription(this.getExportDeploymentXmlAction(context)));
        tbd.add(tbbgd1);
        ToolBarButtonGroupDescription tbbgd2 = new ToolBarButtonGroupDescription();
        tbbgd2.add(new ToolBarButtonDescription(this.getRefreshClassesAction(context)));
        tbbgd2.add(new ToolBarButtonDescription(this.getAddOrRefreshClassesAction(context)));
        tbbgd2.add(new ToolBarButtonDescription(this.getCreateNewClassAction(context)));
        tbd.add(tbbgd2);
        return tbd;
    }

    @Override
    public ComponentContainerDescription buildMenuDescription(WorkbenchContext context) {
        context = this.wrap(context);
        RootMenuDescription md = new RootMenuDescription();
        MenuGroupDescription mgd1 = new MenuGroupDescription();
        mgd1.add(this.buildExportMenuDescription(context));
        md.add(mgd1);
        MenuGroupDescription mgd2 = new MenuGroupDescription();
        mgd2.add(new MenuItemDescription(this.getRefreshClassesAction(context)));
        mgd2.add(new MenuItemDescription(this.getAddOrRefreshClassesAction(context)));
        mgd2.add(new MenuItemDescription(this.getCreateNewClassAction(context)));
        mgd2.add(new MenuItemDescription(this.getManageNonDescriptorClassesAction(context)));
        md.add(mgd2);
        return md;
    }

    @Override
    public PreferencesNode[] buildPreferencesNodes(PreferencesContext context) {
        return new PreferencesNode[]{new MappingsPreferencesNode((PreferencesContext)this.wrap(context))};
    }

    public ProjectIOManager getIOManager() {
        try {
            this.synchronizedIOManager.waitUntilNotNull();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return (ProjectIOManager)this.synchronizedIOManager.getValue();
    }

    public AddOrRefreshClassesAction getAddOrRefreshClassesAction(WorkbenchContext context) {
        return new AddOrRefreshClassesAction(context);
    }

    public AutomapAction getAutomapAction(WorkbenchContext context) {
        return new AutomapAction(context);
    }

    public CreateNewClassAction getCreateNewClassAction(WorkbenchContext context) {
        return new CreateNewClassAction(context);
    }

    public ManageNonDescriptorClassesAction getManageNonDescriptorClassesAction(WorkbenchContext context) {
        return new ManageNonDescriptorClassesAction(context);
    }

    public ExportDeploymentXmlAction getExportDeploymentXmlAction(WorkbenchContext context) {
        return new ExportDeploymentXmlAction(context);
    }

    public ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(WorkbenchContext context) {
        return new ExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(context);
    }

    public ExportJavaSourceAction getExportProjectJavaSourceAction(WorkbenchContext context) {
        return new ExportJavaSourceAction(context);
    }

    public ExportModelJavaSourceAction getExportModelJavaSourceAction(WorkbenchContext context) {
        return new ExportModelJavaSourceAction(context);
    }

    public ExportSpecificDescriptorModelJavaSourceAction getExportSpecificDescriptorModelJavaSourceAction(WorkbenchContext context) {
        return new ExportSpecificDescriptorModelJavaSourceAction(context);
    }

    public RefreshClassesAction getRefreshClassesAction(WorkbenchContext context) {
        return new RefreshClassesAction(context);
    }

    public RemoveAction getRemoveAction(WorkbenchContext context) {
        return new RemoveAction(context);
    }

    public OracleHelpAction getHelpAction(WorkbenchContext context) {
        return new OracleHelpAction(context);
    }

    public ExportTableCreatorJavaSourceAction getExportTableCreatorJavaSourceAction(WorkbenchContext context) {
        return new ExportTableCreatorJavaSourceAction(context);
    }

    public boolean isDevelopmentModeIn(WorkbenchContext context) {
        return context.getApplicationContext().getApplication().isDevelopmentMode();
    }

    private WorkbenchContext wrap(WorkbenchContext context) {
        return context.buildExpandedApplicationContextWorkbenchContext(this.wrap(context.getApplicationContext()));
    }

    ApplicationContext wrap(ApplicationContext context) {
        ApplicationContext expandedContext = context.buildExpandedResourceRepositoryContext(MappingsPluginResourceBundle.class, new MappingsPluginIconResourceFileNameMap());
        expandedContext = expandedContext.buildExpandedResourceRepositoryContext(ProblemsBundle.class);
        return expandedContext.buildRedirectedPreferencesContext(MAPPINGS_PREFERENCES_NODE);
    }

    FrameworkAction buildNewProjectAction(WorkbenchContext context) {
        return new NewProjectAction(this, context);
    }

    ApplicationNode buildProjectNode(MWProject project, WorkbenchContext context) {
        return ProjectNode.forProject(project, context.getApplicationContext(), this);
    }

    private MenuDescription buildExportMenuDescription(WorkbenchContext context) {
        MenuDescription md = new MenuDescription(context.getApplicationContext().getResourceRepository().getString("EXPORT_MENU"), null, context.getApplicationContext().getResourceRepository().getMnemonic("EXPORT_MENU"), context.getApplicationContext().getResourceRepository().getIcon("file.export"));
        MenuGroupDescription mgd = new MenuGroupDescription();
        mgd.add(new MenuItemDescription(this.getExportDeploymentXmlAction(context)));
        if (this.isDevelopmentModeIn(context)) {
            mgd.add(new MenuItemDescription(this.getExportDeploymentXmlAndInitializeRuntimeDescriptorsAction(context)));
        }
        mgd.add(new MenuItemDescription(this.getExportProjectJavaSourceAction(context)));
        mgd.add(new MenuItemDescription(this.getExportModelJavaSourceAction(context)));
        mgd.add(new MenuItemDescription(this.getExportTableCreatorJavaSourceAction(context)));
        md.add(mgd);
        return md;
    }

    public Component buildPropertiesPage(Class propertiesPageClass) {
        return this.getPropertiesPageCacheEntry(propertiesPageClass).buildPropertiesPage();
    }

    public void releasePropertiesPage(Component propertiesPage) {
        this.getPropertiesPageCacheEntry(propertiesPage.getClass()).releasePropertiesPage(propertiesPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertiesPageCacheEntry getPropertiesPageCacheEntry(Class propertiesPageClass) {
        Map map = this.propertiesPageCache;
        synchronized (map) {
            PropertiesPageCacheEntry entry = (PropertiesPageCacheEntry)this.propertiesPageCache.get(propertiesPageClass);
            if (entry == null) {
                entry = new PropertiesPageCacheEntry(propertiesPageClass, this.mwApplicationContext, (Stack)this.propertiesPageBuilderStack);
                this.propertiesPageCache.put(propertiesPageClass, entry);
            }
            return entry;
        }
    }

    public static File buildExportDirectory(MWProject project, String directoryName, Preferences preferences) {
        File directory = new File(directoryName);
        if (StringTools.stringIsEmpty((String)directoryName) || directory.isAbsolute()) {
            if (!directory.exists()) {
                directory = project.getSaveDirectory();
            }
            if (directory == null) {
                directory = new File(preferences.get(EXPORT_LOCATION_PREFERENCE, ""));
            }
            if (!directory.exists()) {
                directory = FileTools.userHomeDirectory();
            }
        } else {
            File projectSaveDirectory = project.getSaveDirectory();
            if (projectSaveDirectory == null) {
                directory = new File(preferences.get(EXPORT_LOCATION_PREFERENCE, ""));
                if (!directory.exists()) {
                    directory = FileTools.userHomeDirectory();
                }
            } else if (!(directory = new File(projectSaveDirectory, directory.getPath())).exists()) {
                directory = projectSaveDirectory;
            }
        }
        return directory;
    }

    private static class LocalCallback
    implements LegacyProjectReadCallback {
        private WorkbenchContext context;
        private boolean saveLegacyProjectNow;

        LocalCallback(WorkbenchContext context) {
            this.context = context;
            this.saveLegacyProjectNow = false;
        }

        public void checkLegacyRead(String schemaVersion) {
            LegacyProjectMigrationDialog dialog = new LegacyProjectMigrationDialog(this.context);
            dialog.show();
            if (dialog.wasCanceled()) {
                throw new CancelException();
            }
            this.saveLegacyProjectNow = !dialog.saveLater();
        }

        boolean saveLegacyProjectNow() {
            return this.saveLegacyProjectNow;
        }
    }

    private class PropertiesPageBuilder
    extends Thread {
        PropertiesPageBuilder() {
            super("Properties Page Builder");
            this.setPriority(1);
        }

        @Override
        public void run() {
            while (true) {
                Class propertiesPageClass = null;
                try {
                    propertiesPageClass = (Class)MappingsPlugin.this.propertiesPageBuilderStack.waitToPop();
                }
                catch (InterruptedException ex) {
                    return;
                }
                this.buildPropertiesPage(propertiesPageClass);
            }
        }

        private void buildPropertiesPage(Class propertiesPageClass) {
            try {
                MappingsPlugin.this.getPropertiesPageCacheEntry(propertiesPageClass).installPropertiesPage();
            }
            catch (Throwable ex) {
                new PropertiesPageBuilder().start();
                throw new RuntimeException(ex);
            }
        }
    }

    private static class PropertiesPageCacheEntry {
        private final Class propertiesPageClass;
        private final WorkbenchContext workbenchContext;
        private final Stack propertiesPageBuilderStack;
        private final SynchronizedStack propertiesPages;

        PropertiesPageCacheEntry(Class propertiesPageClass, ApplicationContext applicationContext, Stack propertiesPageBuilderStack) {
            this.propertiesPageClass = propertiesPageClass;
            this.workbenchContext = this.buildWorkbenchContext(applicationContext);
            this.propertiesPageBuilderStack = propertiesPageBuilderStack;
            this.propertiesPages = new SynchronizedStack();
        }

        private WorkbenchContext buildWorkbenchContext(ApplicationContext applicationContext) {
            Class[] resourceBundleClasses = (Class[])ClassTools.getStaticFieldValue((Class)this.propertiesPageClass, (String)"REQUIRED_RESOURCE_BUNDLES");
            for (int i = 0; i < resourceBundleClasses.length; ++i) {
                applicationContext = applicationContext.buildExpandedResourceRepositoryContext(resourceBundleClasses[i]);
            }
            return new ShellWorkbenchContext(applicationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Component buildPropertiesPage() {
            SynchronizedStack synchronizedStack = this.propertiesPages;
            synchronized (synchronizedStack) {
                Component propertiesPage;
                if (this.propertiesPages.isEmpty()) {
                    this.propertiesPageBuilderStack.push((Object)this.propertiesPageClass);
                }
                try {
                    propertiesPage = (Component)this.propertiesPages.waitToPop();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                if (this.propertiesPages.isEmpty()) {
                    this.propertiesPageBuilderStack.push((Object)this.propertiesPageClass);
                }
                return propertiesPage;
            }
        }

        void releasePropertiesPage(Component propertiesPage) {
            this.propertiesPages.push((Object)propertiesPage);
        }

        void installPropertiesPage() throws Throwable {
            try {
                this.propertiesPages.push(ClassTools.newInstance((Class)this.propertiesPageClass, WorkbenchContext.class, (Object)this.workbenchContext));
            }
            catch (Throwable ex) {
                try {
                    this.propertiesPages.push((Object)new EmptyPropertiesPage(this.workbenchContext));
                }
                catch (Throwable ex2) {
                    this.propertiesPages.push(null);
                    throw ex2;
                }
                throw ex;
            }
        }
    }
}

