/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractEnablableFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.AbstractApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db.TableNode;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class RefreshTableAction
extends AbstractEnablableFrameworkAction {
    RefreshTableAction(WorkbenchContext context) {
        super(context);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeIcon("synchronize");
        this.initializeTextAndMnemonic("REFRESH");
        this.initializeToolTipText("REFRESH");
    }

    @Override
    protected void engageValueEnabled(AbstractApplicationNode node) {
        super.engageValueEnabled(node);
        ((TableNode)node).getTable().getDatabase().addPropertyChangeListener("connected", this.getEnabledStateListener());
    }

    @Override
    protected void disengageValueEnabled(AbstractApplicationNode node) {
        super.disengageValueEnabled(node);
        ((TableNode)node).getTable().getDatabase().removePropertyChangeListener("connected", this.getEnabledStateListener());
    }

    private Collection selectedTables() {
        ArrayList<MWTable> selectedTables = new ArrayList<MWTable>();
        ApplicationNode[] selectedTableNodes = this.selectedNodes();
        for (int i = 0; i < selectedTableNodes.length; ++i) {
            selectedTables.add(((TableNode)selectedTableNodes[i]).getTable());
        }
        return selectedTables;
    }

    @Override
    protected void execute() {
        Collection selectedTables = this.selectedTables();
        MWDatabase database = ((MWTable)selectedTables.iterator().next()).getDatabase();
        ArrayList externalTableDescriptions = new ArrayList(selectedTables.size());
        ArrayList<MWTable> nonRefreshedTables = new ArrayList<MWTable>();
        for (MWTable selectedTable : selectedTables) {
            Collection matchingExternalTableDescriptions = CollectionTools.collection((Iterator)selectedTable.matchingExternalTableDescriptions());
            if (matchingExternalTableDescriptions.size() == 1) {
                externalTableDescriptions.add(matchingExternalTableDescriptions.iterator().next());
                continue;
            }
            if (matchingExternalTableDescriptions.size() > 1) {
                DuplicateTablesDialog dialog = new DuplicateTablesDialog(this.getWorkbenchContext(), selectedTable, matchingExternalTableDescriptions);
                dialog.show();
                if (dialog.wasConfirmed()) {
                    externalTableDescriptions.add(dialog.selectedExternalTableDescription());
                    continue;
                }
                nonRefreshedTables.add(selectedTable);
                continue;
            }
            nonRefreshedTables.add(selectedTable);
        }
        database.refreshQualifiedTablesFor(externalTableDescriptions);
        if (nonRefreshedTables.size() > 0) {
            MissingTablesDialog dialog = new MissingTablesDialog(this.getWorkbenchContext(), nonRefreshedTables);
            dialog.show();
        }
    }

    @Override
    protected boolean shouldBeEnabled(ApplicationNode selectedNode) {
        return ((MWTable)((TableNode)selectedNode).getValue()).getDatabase().isConnected();
    }

    private static class DuplicateTablesDialog
    extends AbstractDialog {
        private MWTable table;
        private Vector duplicateExternalTableDescriptions;
        private JList tableList;
        private static final Comparator EXTERNAL_TABLE_DESCRIPTION_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                return Collator.getInstance().compare(((ExternalTableDescription)o1).getQualifiedName(), ((ExternalTableDescription)o2).getQualifiedName());
            }
        };

        DuplicateTablesDialog(WorkbenchContext context, MWTable table, Collection duplicateExternalTableDescriptions) {
            super(context);
            this.table = table;
            this.setTitle(this.resourceRepository().getString("DUPLICATE_TABLES_DIALOG.title", table.qualifiedName()));
            this.duplicateExternalTableDescriptions = new Vector(duplicateExternalTableDescriptions);
            Collections.sort(this.duplicateExternalTableDescriptions, EXTERNAL_TABLE_DESCRIPTION_COMPARATOR);
            this.getOKAction().setEnabled(false);
        }

        ExternalTableDescription selectedExternalTableDescription() {
            return (ExternalTableDescription)this.tableList.getSelectedValue();
        }

        @Override
        protected Component buildMainPanel() {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints contraints = new GridBagConstraints();
            JLabel errorLabel = new JLabel(this.resourceRepository().getString("DUPLICATE_TABLES_DIALOG.message", this.table.qualifiedName()));
            contraints.gridx = 0;
            contraints.gridy = 0;
            contraints.gridwidth = 1;
            contraints.gridheight = 1;
            contraints.weightx = 1.0;
            contraints.weighty = 0.0;
            contraints.fill = 2;
            contraints.anchor = 13;
            contraints.insets = new Insets(0, 0, 0, 0);
            mainPanel.add((Component)errorLabel, contraints);
            this.tableList = SwingComponentFactory.buildList(this.duplicateExternalTableDescriptions);
            this.tableList.setBorder(BorderFactory.createEmptyBorder());
            this.tableList.setFont(new Font("dialog", 0, 12));
            this.tableList.setSelectionMode(0);
            this.tableList.setCellRenderer(this.buildExternalTableDescriptionCellRenderer());
            this.tableList.addListSelectionListener(this.buildExternalTableDescriptionListSelectionListener());
            contraints.gridx = 0;
            contraints.gridy = 1;
            contraints.gridwidth = 1;
            contraints.gridheight = 1;
            contraints.weightx = 1.0;
            contraints.weighty = 1.0;
            contraints.fill = 1;
            contraints.anchor = 10;
            contraints.insets = new Insets(1, 0, 0, 0);
            mainPanel.add((Component)new JScrollPane(this.tableList), contraints);
            return mainPanel;
        }

        private ListCellRenderer buildExternalTableDescriptionCellRenderer() {
            return new SimpleListCellRenderer(){

                @Override
                protected String buildText(Object value) {
                    return ((ExternalTableDescription)value).getQualifiedName();
                }
            };
        }

        void externalTableDescriptionSelectionChanged() {
            this.getOKAction().setEnabled(this.tableList.getSelectedIndex() != -1);
        }

        private ListSelectionListener buildExternalTableDescriptionListSelectionListener() {
            return new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        DuplicateTablesDialog.this.externalTableDescriptionSelectionChanged();
                    }
                }
            };
        }

        @Override
        protected String helpTopicId() {
            return "dialog.duplicateTables";
        }
    }

    private static class MissingTablesDialog
    extends AbstractDialog {
        private Collection missingTables;

        public MissingTablesDialog(WorkbenchContext context, Collection missingTables) {
            super(context);
            this.setTitle(this.resourceRepository().getString("ERROR_REFRESHING_TABLES_DIALOG.title"));
            this.missingTables = new TreeSet(missingTables);
        }

        @Override
        protected Component buildMainPanel() {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints contraints = new GridBagConstraints();
            JLabel errorLabel = new JLabel(this.resourceRepository().getString("ERROR_REFRESHING_TABLES_DIALOG.message"));
            contraints.gridx = 0;
            contraints.gridy = 0;
            contraints.gridwidth = 1;
            contraints.gridheight = 1;
            contraints.weightx = 1.0;
            contraints.weighty = 0.0;
            contraints.fill = 2;
            contraints.anchor = 13;
            contraints.insets = new Insets(0, 0, 0, 0);
            mainPanel.add((Component)errorLabel, contraints);
            JTextArea textArea = new JTextArea();
            textArea.setBorder(BorderFactory.createEmptyBorder());
            textArea.setFont(new Font("dialog", 0, 12));
            textArea.setEditable(false);
            contraints.gridx = 0;
            contraints.gridy = 1;
            contraints.gridwidth = 1;
            contraints.gridheight = 1;
            contraints.weightx = 1.0;
            contraints.weighty = 1.0;
            contraints.fill = 1;
            contraints.anchor = 10;
            contraints.insets = new Insets(1, 0, 0, 0);
            mainPanel.add((Component)new JScrollPane(textArea), contraints);
            textArea.setText(null);
            Iterator stream = this.missingTables.iterator();
            while (stream.hasNext()) {
                textArea.append(((MWTable)stream.next()).qualifiedName());
                if (!stream.hasNext()) continue;
                textArea.append(StringTools.CR);
            }
            return mainPanel;
        }

        @Override
        protected String helpTopicId() {
            return "dialog.tablesNotFound";
        }
    }
}

