/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public class TableModelAdapter
extends AbstractTableModel {
    private ListValueModel listHolder;
    private ListChangeListener listChangeListener;
    private ArrayList rows;
    private ColumnAdapter columnAdapter;
    private PropertyChangeListener cellListener;

    private TableModelAdapter() {
        this.initialize();
    }

    public TableModelAdapter(ListValueModel listHolder, ColumnAdapter columnAdapter) {
        this();
        if (listHolder == null) {
            throw new NullPointerException();
        }
        this.listHolder = listHolder;
        this.columnAdapter = columnAdapter;
    }

    public TableModelAdapter(CollectionValueModel collectionHolder, ColumnAdapter columnAdapter) {
        this(new CollectionListValueModelAdapter(collectionHolder), columnAdapter);
    }

    private void initialize() {
        this.listChangeListener = this.buildListChangeListener();
        this.rows = new ArrayList();
        this.cellListener = this.buildCellListener();
    }

    private ListChangeListener buildListChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                TableModelAdapter.this.addRows(e.getIndex(), e.size(), e.items());
            }

            public void itemsRemoved(ListChangeEvent e) {
                TableModelAdapter.this.removeRows(e.getIndex(), e.size());
            }

            public void itemsReplaced(ListChangeEvent e) {
                TableModelAdapter.this.replaceRows(e.getIndex(), e.items());
            }

            public void listChanged(ListChangeEvent e) {
                TableModelAdapter.this.rebuildTable();
            }

            public String toString() {
                return "list listener";
            }
        };
    }

    private PropertyChangeListener buildCellListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableModelAdapter.this.cellChanged((PropertyValueModel)evt.getSource());
            }

            public String toString() {
                return "cell listener";
            }
        };
    }

    @Override
    public int getColumnCount() {
        return this.columnAdapter.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnAdapter.getColumnName(column);
    }

    public Class getColumnClass(int columnIndex) {
        return this.columnAdapter.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columnAdapter.isColumnEditable(columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PropertyValueModel[] row = (PropertyValueModel[])this.rows.get(rowIndex);
        return row[columnIndex].getValue();
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex < this.rows.size()) {
            PropertyValueModel[] row = (PropertyValueModel[])this.rows.get(rowIndex);
            row[columnIndex].setValue(value);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.hasNoTableModelListeners()) {
            this.engageModel();
        }
        super.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
        if (this.hasNoTableModelListeners()) {
            this.disengageModel();
        }
    }

    public ListValueModel getModel() {
        return this.listHolder;
    }

    public void setModel(ListValueModel listHolder) {
        if (listHolder == null) {
            throw new NullPointerException();
        }
        boolean hasListeners = this.hasTableModelListeners();
        if (hasListeners) {
            this.disengageModel();
        }
        this.listHolder = listHolder;
        if (hasListeners) {
            this.engageModel();
            this.fireTableDataChanged();
        }
    }

    public void setModel(CollectionValueModel collectionHolder) {
        this.setModel(new CollectionListValueModelAdapter(collectionHolder));
    }

    protected boolean hasNoTableModelListeners() {
        return this.listenerList.getListenerCount(TableModelListener.class) == 0;
    }

    protected boolean hasTableModelListeners() {
        return !this.hasNoTableModelListeners();
    }

    private void engageModel() {
        this.listHolder.addListChangeListener("value", this.listChangeListener);
        this.engageAllCells();
    }

    private void engageAllCells() {
        this.rows.ensureCapacity(this.listHolder.size());
        Iterator stream = (Iterator)this.listHolder.getValue();
        while (stream.hasNext()) {
            PropertyValueModel[] row = this.columnAdapter.cellModels(stream.next());
            this.engageRow(row);
            this.rows.add(row);
        }
    }

    private void engageRow(PropertyValueModel[] row) {
        int i = row.length;
        while (i-- > 0) {
            row[i].addPropertyChangeListener("value", this.cellListener);
        }
    }

    private void disengageModel() {
        this.disengageAllCells();
        this.listHolder.removeListChangeListener("value", this.listChangeListener);
    }

    private void disengageAllCells() {
        Iterator stream = this.rows.iterator();
        while (stream.hasNext()) {
            this.disengageRow((PropertyValueModel[])stream.next());
        }
        this.rows.clear();
    }

    private void disengageRow(PropertyValueModel[] row) {
        int i = row.length;
        while (i-- > 0) {
            row[i].removePropertyChangeListener("value", this.cellListener);
        }
    }

    void cellChanged(PropertyValueModel cellHolder) {
        int i = this.rows.size();
        while (i-- > 0) {
            PropertyValueModel[] row = (PropertyValueModel[])this.rows.get(i);
            int j = row.length;
            while (j-- > 0) {
                if (row[j] != cellHolder) continue;
                this.fireTableCellUpdated(i, j);
            }
        }
    }

    void addRows(int index, int size, Iterator items) {
        ArrayList<PropertyValueModel[]> newRows = new ArrayList<PropertyValueModel[]>(size);
        while (items.hasNext()) {
            PropertyValueModel[] row = this.columnAdapter.cellModels(items.next());
            this.engageRow(row);
            newRows.add(row);
        }
        this.rows.addAll(index, newRows);
        this.fireTableRowsInserted(index, index + size - 1);
    }

    void removeRows(int index, int size) {
        for (int i = 0; i < size; ++i) {
            PropertyValueModel[] row = (PropertyValueModel[])this.rows.remove(index);
            this.disengageRow(row);
        }
        this.fireTableRowsDeleted(index, index + size - 1);
    }

    void replaceRows(int index, Iterator items) {
        int i = index;
        while (items.hasNext()) {
            PropertyValueModel[] row = (PropertyValueModel[])this.rows.get(i);
            this.disengageRow(row);
            row = this.columnAdapter.cellModels(items.next());
            this.engageRow(row);
            this.rows.set(i, row);
            ++i;
        }
        this.fireTableRowsUpdated(index, --i);
    }

    void rebuildTable() {
        this.disengageAllCells();
        this.engageAllCells();
        this.fireTableDataChanged();
    }
}

