/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeObjectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.InterfaceDescriptorCreationException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlPrimaryKeyPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWNamedSchemaComponentHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMappingFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRefreshPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.xml.MWXmlProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWComplexTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWElementDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWModelGroupDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWNamedSchemaComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSimpleTypeDefinition;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlNode;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWXmlDescriptor
extends MWMappingDescriptor
implements MWXmlNode {
    private MWNamedSchemaComponentHandle schemaContextHandle;
    public static final String SCHEMA_CONTEXT_PROPERTY = "schemaContext";
    private MWNamedSchemaComponentHandle defaultRootElementHandle;
    public static final String DEFAULT_ROOT_ELEMENT_PROPERTY = "defaultRootElement";

    protected MWXmlDescriptor() {
    }

    public MWXmlDescriptor(MWXmlProject project, MWClass type, String name) {
        super(project, type, name);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.schemaContextHandle = new MWNamedSchemaComponentHandle(this, this.buildSchemaContextScrubber());
        this.defaultRootElementHandle = new MWNamedSchemaComponentHandle(this, this.buildDefaultRootElementScrubber());
    }

    protected void initializeFromMWXmlDescriptor(MWXmlDescriptor oldDescriptor) {
        super.initializeFromMWMappingDescriptor(oldDescriptor);
        this.setSchemaContext(oldDescriptor.getSchemaContext());
        this.setDefaultRootElement(oldDescriptor.getDefaultRootElement());
    }

    public MWSchemaContextComponent getSchemaContext() {
        return (MWSchemaContextComponent)this.schemaContextHandle.getComponent();
    }

    public void setSchemaContext(MWSchemaContextComponent newContext) {
        MWSchemaContextComponent oldContext = this.getSchemaContext();
        this.schemaContextHandle.setComponent(newContext);
        this.firePropertyChanged(SCHEMA_CONTEXT_PROPERTY, oldContext, newContext);
        this.setInitialDefaultRootElement();
        this.resolveXpaths();
    }

    @Override
    public abstract boolean isRootDescriptor();

    public abstract boolean isEisDescriptor();

    public MWElementDeclaration getDefaultRootElement() {
        return (MWElementDeclaration)this.defaultRootElementHandle.getComponent();
    }

    public void setDefaultRootElement(MWElementDeclaration newDefaultRootElement) {
        MWElementDeclaration oldDefaultRootElement = this.getDefaultRootElement();
        this.defaultRootElementHandle.setComponent(newDefaultRootElement);
        this.firePropertyChanged(DEFAULT_ROOT_ELEMENT_PROPERTY, oldDefaultRootElement, newDefaultRootElement);
    }

    protected void setInitialDefaultRootElement() {
        if (this.getSchemaContext() instanceof MWElementDeclaration) {
            this.setDefaultRootElement((MWElementDeclaration)this.getSchemaContext());
        }
    }

    @Override
    public abstract MWMappingFactory mappingFactory();

    public MWCompositeObjectMapping addCompositeObjectMapping(MWClassAttribute attribute) {
        MWCompositeObjectMapping mapping = ((MWXmlMappingFactory)this.mappingFactory()).createCompositeObjectMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    public MWCompositeCollectionMapping addCompositeCollectionMapping(MWClassAttribute attribute) {
        MWCompositeCollectionMapping mapping = ((MWXmlMappingFactory)this.mappingFactory()).createCompositeCollectionMapping(this, attribute, attribute.getName());
        this.addMapping(mapping);
        return mapping;
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.schemaContextHandle);
        children.add(this.defaultRootElementHandle);
    }

    private MWHandle.NodeReferenceScrubber buildSchemaContextScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWXmlDescriptor.this.setSchemaContext(null);
            }

            public String toString() {
                return "MWXmlDescriptor.buildSchemaContextScrubber()";
            }
        };
    }

    private MWHandle.NodeReferenceScrubber buildDefaultRootElementScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWXmlDescriptor.this.setDefaultRootElement(null);
            }

            public String toString() {
                return "MWXmlDescriptor.buildDefaultRootElementtScrubber()";
            }
        };
    }

    @Override
    protected void refreshClass(MWClassRefreshPolicy refreshPolicy) throws ExternalClassNotFoundException, InterfaceDescriptorCreationException {
        super.refreshClass(refreshPolicy);
        if (this.getMWClass().isInterface()) {
            throw new InterfaceDescriptorCreationException(this.getMWClass());
        }
    }

    @Override
    public void resolveXpaths() {
        ((MWXmlNode)((Object)this.getInheritancePolicy())).resolveXpaths();
        ((MWXmlNode)((Object)this.getLockingPolicy())).resolveXpaths();
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).resolveXpaths();
        }
    }

    @Override
    public void schemaChanged(SchemaChange change) {
        if (this.getSchemaContext() == null || this.getSchemaContext().getSchema() != change.getSchema()) {
            return;
        }
        ((MWXmlNode)((Object)this.getInheritancePolicy())).schemaChanged(change);
        ((MWXmlNode)((Object)this.getLockingPolicy())).schemaChanged(change);
        Iterator stream = this.mappings();
        while (stream.hasNext()) {
            ((MWXmlNode)stream.next()).schemaChanged(change);
        }
    }

    @Override
    protected void addProblemsTo(List newProblems) {
        super.addProblemsTo(newProblems);
        this.addSchemaContextNotSpecifiedProblemTo(newProblems);
        this.addDefaultRootElementNotSpecifiedProblemTo(newProblems);
    }

    private void addSchemaContextNotSpecifiedProblemTo(List newProblems) {
        if (this.schemaContextIsRequired() && this.getSchemaContext() == null) {
            newProblems.add(this.buildProblem("0270"));
        }
    }

    @Override
    public Collection allWritableMappingsForField(MWDataField field) {
        ArrayList<MWMapping> mappingsForField = new ArrayList<MWMapping>();
        Iterator mappings = this.mappings();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            if (mapping.isReadOnly()) continue;
            ArrayList writtenFields = new ArrayList();
            mapping.addWrittenFieldsTo(writtenFields);
            for (MWXmlField writtenField : writtenFields) {
                if (!writtenField.getXpath().equals(((MWXmlField)field).getXpath())) continue;
                mappingsForField.add(mapping);
            }
        }
        if (!this.writableMappingsForField(field).isEmpty() && !this.getInheritancePolicy().isRoot() && this.getInheritancePolicy().getParentDescriptor() != null) {
            for (MWMapping nextInheritedMapping : this.getInheritancePolicy().getParentDescriptor().writableMappingsForField(field)) {
                MWMapping inheritedMappingInThisDescriptor = this.mappingNamed(nextInheritedMapping.getName());
                if (inheritedMappingInThisDescriptor != null) continue;
                mappingsForField.add(nextInheritedMapping);
            }
        }
        return mappingsForField;
    }

    @Override
    public Collection writableMappingsForField(MWDataField field) {
        ArrayList<MWMapping> mappingsForField = new ArrayList<MWMapping>();
        Iterator mappings = this.mappings();
        while (mappings.hasNext()) {
            MWMapping mapping = (MWMapping)mappings.next();
            ArrayList writtenFields = new ArrayList();
            mapping.addWrittenFieldsTo(writtenFields);
            for (MWXmlField writtenField : writtenFields) {
                if (!writtenField.getXpath().equals(((MWXmlField)field).getXpath())) continue;
                mappingsForField.add(mapping);
            }
        }
        return mappingsForField;
    }

    protected boolean schemaContextIsRequired() {
        return true;
    }

    private void addDefaultRootElementNotSpecifiedProblemTo(List newProblems) {
        if (this.isRootDescriptor() && this.getDefaultRootElement() == null) {
            newProblems.add(this.buildProblem("0271"));
        }
    }

    @Override
    protected String multipleMappingsWriteFieldProblemResourceStringKey() {
        return "0272";
    }

    @Override
    public ClassDescriptor buildRuntimeDescriptor() {
        ClassDescriptor runtimeDescriptor = super.buildRuntimeDescriptor();
        this.adjustRuntimeDescriptorRootProperties(runtimeDescriptor);
        return runtimeDescriptor;
    }

    protected void adjustRuntimeDescriptorRootProperties(ClassDescriptor runtimeDescriptor) {
        if (!this.isRootDescriptor()) {
            runtimeDescriptor.descriptorIsAggregate();
        }
    }

    @Override
    protected Comparator orderedMappingComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                MWXmlField xmlField1 = ((MWXmlMapping)o1).firstMappedXmlField();
                MWXmlField xmlField2 = ((MWXmlMapping)o2).firstMappedXmlField();
                return MWXmlField.compareSchemaOrder(xmlField1, xmlField2);
            }
        };
    }

    protected XMLSchemaReference runtimeSchemaReference() {
        MWSchemaContextComponent context = this.getSchemaContext();
        if (context != null) {
            XMLSchemaReference runtimeSchemaRef = context.getSchema().runtimeSchemaReference();
            String runtimeSchemaContext = "";
            Iterator stream = context.namedComponentChain();
            while (stream.hasNext()) {
                runtimeSchemaContext = "/" + ((MWNamedSchemaComponent)stream.next()).qName() + runtimeSchemaContext;
            }
            runtimeSchemaRef.setSchemaContext(runtimeSchemaContext);
            if (context instanceof MWComplexTypeDefinition) {
                runtimeSchemaRef.setType(1);
            } else if (context instanceof MWSimpleTypeDefinition) {
                runtimeSchemaRef.setType(2);
            } else if (context instanceof MWElementDeclaration) {
                runtimeSchemaRef.setType(3);
            } else if (context instanceof MWModelGroupDefinition) {
                runtimeSchemaRef.setType(5);
            }
            return runtimeSchemaRef;
        }
        return null;
    }

    protected NamespaceResolver runtimeNamespaceResolver() {
        if (this.getSchemaContext() != null) {
            return this.getSchemaContext().getSchema().runtimeNamespaceResolver();
        }
        return null;
    }

    public abstract AbstractDirectMapping buildDefaultRuntimeDirectMapping();

    public abstract AbstractCompositeDirectCollectionMapping buildDefaultRuntimeDirectCollectionMapping();

    public abstract AbstractCompositeObjectMapping buildDefaultRuntimeCompositeObjectMapping();

    public abstract AbstractCompositeCollectionMapping buildDefaultRuntimeCompositeCollectionMapping();

    public abstract AbstractTransformationMapping buildDefaultRuntimeTransformationMapping();

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWXmlDescriptor.class);
        descriptor.getInheritancePolicy().setParentClass(MWMappingDescriptor.class);
        XMLCompositeObjectMapping schemaContextHandleMapping = new XMLCompositeObjectMapping();
        schemaContextHandleMapping.setAttributeName("schemaContextHandle");
        schemaContextHandleMapping.setGetMethodName("getSchemaContextHandleForTopLink");
        schemaContextHandleMapping.setSetMethodName("setSchemaContextHandleForTopLink");
        schemaContextHandleMapping.setReferenceClass(MWNamedSchemaComponentHandle.class);
        schemaContextHandleMapping.setXPath("schema-context-handle");
        descriptor.addMapping((DatabaseMapping)schemaContextHandleMapping);
        XMLCompositeObjectMapping defaultRootElementHandleMapping = new XMLCompositeObjectMapping();
        defaultRootElementHandleMapping.setAttributeName("defaultRootElementHandle");
        defaultRootElementHandleMapping.setGetMethodName("getDefaultRootElementHandleForTopLink");
        defaultRootElementHandleMapping.setSetMethodName("setDefaultRootElementHandleForTopLink");
        defaultRootElementHandleMapping.setReferenceClass(MWNamedSchemaComponentHandle.class);
        defaultRootElementHandleMapping.setXPath("default-root-element-handle");
        descriptor.addMapping((DatabaseMapping)defaultRootElementHandleMapping);
        return descriptor;
    }

    private MWNamedSchemaComponentHandle getSchemaContextHandleForTopLink() {
        return this.schemaContextHandle.getComponent() == null ? null : this.schemaContextHandle;
    }

    private void setSchemaContextHandleForTopLink(MWNamedSchemaComponentHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildSchemaContextScrubber();
        this.schemaContextHandle = handle == null ? new MWNamedSchemaComponentHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    private MWNamedSchemaComponentHandle getDefaultRootElementHandleForTopLink() {
        return this.defaultRootElementHandle.getComponent() == null ? null : this.defaultRootElementHandle;
    }

    private void setDefaultRootElementHandleForTopLink(MWNamedSchemaComponentHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildDefaultRootElementScrubber();
        this.defaultRootElementHandle = handle == null ? new MWNamedSchemaComponentHandle(this, scrubber) : handle.setScrubber(scrubber);
    }

    public abstract MWXmlPrimaryKeyPolicy primaryKeyPolicy();
}

