/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader;

import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassDescription;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.ExternalClassNotFoundException;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.AbstractCLExternalClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.meta.classloader.CLExternalClass;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

final class CLExternalClassDescription
implements ExternalClassDescription {
    private final String name;
    private final String classpathEntry;
    private final AbstractCLExternalClassRepository repository;
    private ExternalClass externalClass;

    CLExternalClassDescription(String name, String classpathEntry, AbstractCLExternalClassRepository repository) {
        this.name = name;
        this.classpathEntry = classpathEntry;
        this.repository = repository;
    }

    CLExternalClassDescription(String name, AbstractCLExternalClassRepository repository) {
        this(name, "", repository);
    }

    @Override
    public int getArrayDepth() {
        return ClassTools.arrayDepthForClassNamed(this.name);
    }

    @Override
    public String getAdditionalInfo() {
        return this.classpathEntry;
    }

    @Override
    public String getElementTypeName() {
        return ClassTools.elementTypeNameForClassNamed(this.name);
    }

    @Override
    public synchronized ExternalClass getExternalClass() throws ExternalClassNotFoundException {
        if (this.externalClass == null) {
            this.externalClass = this.buildExternalClass();
        }
        return this.externalClass;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSynthetic() {
        return ClassTools.classNamedIsAnonymous(this.name);
    }

    public String toString() {
        return StringTools.buildToStringFor(this, this.getName());
    }

    ExternalClassDescription classDescriptionFor(Class javaClass) {
        return this.repository.getClassDescriptionFor(javaClass);
    }

    private ExternalClass buildExternalClass() throws ExternalClassNotFoundException {
        if (this.getArrayDepth() != 0) {
            throw new IllegalStateException();
        }
        return new CLExternalClass(this.repository.loadClass(this.name), this);
    }
}

