/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.jpa.xml.inheritance;

import java.io.Serializable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.Company;
import org.eclipse.persistence.tools.schemaframework.ViewDefinition;

public class Vehicle
implements Serializable {
    private Number id;
    private Company owner;
    private Integer passengerCapacity;

    public void change() {
    }

    public Number getId() {
        return this.id;
    }

    public void setId(Number id) {
        this.id = id;
    }

    public Company getOwner() {
        return this.owner;
    }

    public void setOwner(Company ownerCompany) {
        this.owner = ownerCompany;
    }

    public Integer getPassengerCapacity() {
        return this.passengerCapacity;
    }

    public void setPassengerCapacity(Integer capacity) {
        this.passengerCapacity = capacity;
    }

    public static ViewDefinition oracleView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllVehicles");
        definition.setSelectClause("Select V.*, F.FUEL_CAP, F.FUEL_TYP, B.DESCRIP, B.DRIVER_ID, C.CDESCRIP from VEHICLE V, FUEL_VEH F, BUS B, CAR C where V.ID = F.ID (+) AND V.ID = B.ID (+) AND V.ID = C.ID (+)");
        return definition;
    }

    public static ViewDefinition sybaseView() {
        ViewDefinition definition = new ViewDefinition();
        definition.setName("AllVehicles");
        definition.setSelectClause("Select V.*, F.FUEL_CAP, F.FUEL_TYP, B.DESCRIP, B.DRIVER_ID, C.CDESCRIP from VEHICLE V, FUEL_VEH F, BUS B, CAR C where V.ID *= F.ID AND V.ID *= B.ID AND V.ID *= C.ID");
        return definition;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.id + ")";
    }
}

