/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWMethodHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWMethod;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorCopyPolicy
extends MWAbstractDescriptorPolicy {
    private MWMethodHandle methodHandle;
    private volatile String policyType;
    public static final String COPY_POLICY_PROPERTY = "copyPolicy";
    public static final String CLONE = "clone";
    public static final String INSTANTIATION_POLICY = "instantiation";
    public static final String CONSTRUCTOR = "constructor";
    public static final String CONSTRUCTOR_PROPERTY = "constructor";
    public static final String COPY_POLICY_TYPE_PROPERTY = "copyPolicyType";
    public static final String COPY_METHOD_PROPERTY = "copyMethod";

    private MWDescriptorCopyPolicy() {
    }

    public MWDescriptorCopyPolicy(MWMappingDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.methodHandle = new MWMethodHandle(this, this.buildMethodScrubber());
        this.policyType = INSTANTIATION_POLICY;
    }

    public MWMethod getMethod() {
        return this.methodHandle.getMethod();
    }

    public void setMethod(MWMethod newMethod) {
        MWMethod oldMethod = this.methodHandle.getMethod();
        this.methodHandle.setMethod(newMethod);
        this.firePropertyChanged(COPY_METHOD_PROPERTY, oldMethod, newMethod);
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public void setPolicyType(String policyType) {
        String oldValue = this.policyType;
        this.policyType = policyType;
        this.firePropertyChanged(COPY_POLICY_TYPE_PROPERTY, oldValue, this.policyType);
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.methodHandle);
    }

    private MWHandle.NodeReferenceScrubber buildMethodScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            @Override
            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWDescriptorCopyPolicy.this.setMethod(null);
            }

            public String toString() {
                return "MWDescriptorCopyPolicy.buildMethodScrubber()";
            }
        };
    }

    @Override
    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        MWMethod method;
        if (this.policyType == INSTANTIATION_POLICY) {
            runtimeDescriptor.useInstantiationCopyPolicy();
        } else if (this.policyType == CLONE && (method = this.getMethod()) != null) {
            runtimeDescriptor.useCloneCopyPolicy(method.getName());
        }
    }

    @Override
    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.checkCloneCopyPolicy(problems);
    }

    private void checkCloneCopyPolicy(List newProblems) {
        if (this.getPolicyType() == CLONE) {
            if (this.getMethod() == null) {
                newProblems.add(this.buildProblem("0317"));
            } else if (!this.checkIfMethodIsInOwningClass()) {
                newProblems.add(this.buildProblem("0318"));
            } else if (!this.getMethod().isCandidateCloneMethod()) {
                newProblems.add(this.buildProblem("0346"));
            }
        }
    }

    public boolean checkIfMethodIsInOwningClass() {
        return CollectionTools.contains(this.getOwningDescriptor().getMWClass().allMethods(), (Object)this.getMethod());
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.getPolicyType());
        sb.append(", method=");
        sb.append(this.getMethod());
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorCopyPolicy.class);
        ObjectTypeConverter policyTypeConverter = new ObjectTypeConverter();
        policyTypeConverter.addConversionValue((Object)INSTANTIATION_POLICY, (Object)INSTANTIATION_POLICY);
        policyTypeConverter.addConversionValue((Object)CLONE, (Object)CLONE);
        policyTypeConverter.setDefaultAttributeValue((Object)INSTANTIATION_POLICY);
        XMLDirectMapping policyTypeMapping = new XMLDirectMapping();
        policyTypeMapping.setAttributeName("policyType");
        policyTypeMapping.setXPath("policy-type/text()");
        policyTypeMapping.setNullValue((Object)INSTANTIATION_POLICY);
        policyTypeMapping.setConverter((Converter)policyTypeConverter);
        descriptor.addMapping((DatabaseMapping)policyTypeMapping);
        XMLCompositeObjectMapping methodHandleMapping = new XMLCompositeObjectMapping();
        methodHandleMapping.setAttributeName("methodHandle");
        methodHandleMapping.setGetMethodName("getMethodHandleForTopLink");
        methodHandleMapping.setSetMethodName("setMethodHandleForTopLink");
        methodHandleMapping.setReferenceClass(MWMethodHandle.class);
        methodHandleMapping.setXPath("copy-policy-method-handle");
        descriptor.addMapping((DatabaseMapping)methodHandleMapping);
        return descriptor;
    }

    private MWMethodHandle getMethodHandleForTopLink() {
        return this.methodHandle.getMethod() == null ? null : this.methodHandle;
    }

    private void setMethodHandleForTopLink(MWMethodHandle handle) {
        MWHandle.NodeReferenceScrubber scrubber = this.buildMethodScrubber();
        this.methodHandle = handle == null ? new MWMethodHandle(this, scrubber) : handle.setScrubber(scrubber);
    }
}

