/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorQueryParameterHandle
extends MWHandle {
    private volatile MWQueryParameter queryParameter;
    private volatile String classDescriptorName;
    private volatile String querySignature;
    private volatile String queryParameterName;

    private MWDescriptorQueryParameterHandle() {
    }

    public MWDescriptorQueryParameterHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWDescriptorQueryParameterHandle(MWModel parent, MWQueryParameter queryParameter, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.queryParameter = queryParameter;
    }

    public MWQueryParameter getQueryParameter() {
        return this.queryParameter;
    }

    public void setQueryParameter(MWQueryParameter queryParameter) {
        this.queryParameter = queryParameter;
    }

    @Override
    protected Node node() {
        return this.getQueryParameter();
    }

    public MWDescriptorQueryParameterHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void postProjectBuild() {
        MWQuery query;
        MWTableDescriptor classDescriptor;
        super.postProjectBuild();
        if (this.classDescriptorName != null && this.querySignature != null && this.queryParameterName != null && (classDescriptor = (MWTableDescriptor)this.getProject().descriptorNamed(this.classDescriptorName)) != null && (query = classDescriptor.getQueryManager().queryWithSignature(this.querySignature)) != null) {
            this.queryParameter = query.getParameterNamed(this.queryParameterName);
        }
        this.classDescriptorName = null;
        this.querySignature = null;
        this.queryParameterName = null;
    }

    public int compareTo(Object o) {
        return this.queryParameter.compareTo(((MWDescriptorQueryParameterHandle)o).queryParameter);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.queryParameter == null) {
            sb.append("null");
        } else {
            this.queryParameter.toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDescriptorQueryParameterHandle.class);
        descriptor.addDirectMapping("classDescriptorName", "getClassDescriptorNameForTopLink", "setClassDescriptorNameForTopLink", "class-descriptor-name/text()");
        descriptor.addDirectMapping("querySignature", "getQuerySignatureForTopLink", "setQuerySignatureForTopLink", "query-signature/text()");
        descriptor.addDirectMapping("queryParameterName", "getQueryParameterNameForTopLink", "setQueryParameterNameForTopLink", "query-parameter-name/text()");
        return descriptor;
    }

    private String getClassDescriptorNameForTopLink() {
        return this.queryParameter == null ? null : this.queryParameter.getQuery().getOwningDescriptor().getName();
    }

    private void setClassDescriptorNameForTopLink(String classDescriptorName) {
        this.classDescriptorName = classDescriptorName;
    }

    private String getQuerySignatureForTopLink() {
        return this.queryParameter == null ? null : this.queryParameter.getQuery().signature();
    }

    private void setQuerySignatureForTopLink(String querySignature) {
        this.querySignature = querySignature;
    }

    private String getQueryParameterNameForTopLink() {
        return this.queryParameter == null ? null : this.queryParameter.getName();
    }

    private void setQueryParameterNameForTopLink(String queryParameterName) {
        this.queryParameterName = queryParameterName;
    }
}

