/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWNullValuePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDefaultNullValuePolicy
extends MWModel
implements MWNullValuePolicy {
    private volatile String nullValue;
    private volatile MWTypeDeclaration nullValueType;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWDefaultNullValuePolicy.class);
        XMLCompositeObjectMapping nullValueTypeMapping = new XMLCompositeObjectMapping();
        nullValueTypeMapping.setAttributeName("nullValueType");
        nullValueTypeMapping.setReferenceClass(MWTypeDeclaration.class);
        nullValueTypeMapping.setXPath("null-value-type");
        descriptor.addMapping((DatabaseMapping)nullValueTypeMapping);
        XMLDirectMapping nullValueMapping = (XMLDirectMapping)descriptor.addDirectMapping("nullValue", "null-value/text()");
        nullValueMapping.setNullValue((Object)"");
        return descriptor;
    }

    private MWDefaultNullValuePolicy() {
    }

    public MWDefaultNullValuePolicy(MWModel parent) {
        super(parent);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.nullValueType = new MWTypeDeclaration((MWModel)this, this.typeFor(String.class));
        this.nullValue = "";
    }

    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.nullValueType);
    }

    @Override
    public boolean usesNullValue() {
        return true;
    }

    @Override
    public String getNullValue() {
        return this.nullValue;
    }

    @Override
    public void setNullValue(String newValue) {
        String oldValue = this.nullValue;
        this.nullValue = newValue;
        this.firePropertyChanged("nullValue", oldValue, newValue);
    }

    @Override
    public MWTypeDeclaration getNullValueType() {
        return this.nullValueType;
    }

    @Override
    public void setNullValueType(MWTypeDeclaration newNullType) {
        if (newNullType == null) {
            throw new NullPointerException();
        }
        MWTypeDeclaration oldValue = this.getNullValueType();
        this.nullValueType = newNullType;
        this.firePropertyChanged("nullValueType", oldValue, newNullType);
    }

    @Override
    public void adjustRuntimeMapping(AbstractDirectMapping mapping) {
        mapping.setNullValue(this.nullValue());
    }

    protected Object nullValue() {
        if (this.nullValue == null || this.getNullValueType() == null) {
            return null;
        }
        Class<?> nullClass = null;
        try {
            nullClass = Class.forName(this.getNullValueType().typeName());
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        ConversionManager cm = ConversionManager.getDefaultManager();
        try {
            return cm.convertObject((Object)this.nullValue, nullClass);
        }
        catch (ConversionException ce) {
            return null;
        }
    }

    @Override
    public MWNullValuePolicy getValueForTopLink() {
        return this;
    }
}

