/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.string;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.tools.workbench.utility.string.PartialStringComparatorEngine;
import org.eclipse.persistence.tools.workbench.utility.string.StringHolder;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class AffixStrippingPartialStringComparatorEngine
implements PartialStringComparatorEngine {
    private final PartialStringComparatorEngine engine;
    private final ThresholdCalculator thresholdCalculator;
    private final StringHolderWrapperFactory wrapperFactory;

    public static PartialStringComparatorEngine forPrefixStripping(PartialStringComparatorEngine engine) {
        return new AffixStrippingPartialStringComparatorEngine(engine, StringHolderWrapperFactory.PREFIX);
    }

    public static PartialStringComparatorEngine forPrefixStripping(PartialStringComparatorEngine engine, float factor) {
        return new AffixStrippingPartialStringComparatorEngine(engine, factor, StringHolderWrapperFactory.PREFIX);
    }

    public static PartialStringComparatorEngine forPrefixStripping(PartialStringComparatorEngine engine, int count) {
        return new AffixStrippingPartialStringComparatorEngine(engine, count, StringHolderWrapperFactory.PREFIX);
    }

    public static PartialStringComparatorEngine forSuffixStripping(PartialStringComparatorEngine engine) {
        return new AffixStrippingPartialStringComparatorEngine(engine, StringHolderWrapperFactory.SUFFIX);
    }

    public static PartialStringComparatorEngine forSuffixStripping(PartialStringComparatorEngine engine, float factor) {
        return new AffixStrippingPartialStringComparatorEngine(engine, factor, StringHolderWrapperFactory.SUFFIX);
    }

    public static PartialStringComparatorEngine forSuffixStripping(PartialStringComparatorEngine engine, int count) {
        return new AffixStrippingPartialStringComparatorEngine(engine, count, StringHolderWrapperFactory.SUFFIX);
    }

    private AffixStrippingPartialStringComparatorEngine(PartialStringComparatorEngine engine, StringHolderWrapperFactory wrapperFactory) {
        this(engine, 1.0f, wrapperFactory);
    }

    private AffixStrippingPartialStringComparatorEngine(PartialStringComparatorEngine engine, float factor, StringHolderWrapperFactory wrapperFactory) {
        this.engine = engine;
        this.thresholdCalculator = new VariableThresholdCalculator(factor);
        this.wrapperFactory = wrapperFactory;
    }

    private AffixStrippingPartialStringComparatorEngine(PartialStringComparatorEngine engine, int count, StringHolderWrapperFactory wrapperFactory) {
        this.engine = engine;
        this.thresholdCalculator = new FixedThresholdCalculator(count);
        this.wrapperFactory = wrapperFactory;
    }

    @Override
    public PartialStringComparatorEngine.StringHolderPair[] match(StringHolder[] stringHolders1, StringHolder[] stringHolders2) {
        return this.unwrap(this.engine.match(this.wrap(stringHolders1), this.wrap(stringHolders2)));
    }

    private StringHolder[] wrap(StringHolder[] stringHolders) {
        int thresholdCount;
        int len = stringHolders.length;
        StringHolder[] wrappers = new StringHolderWrapper[len];
        int i = len;
        while (i-- > 0) {
            wrappers[i] = this.wrap(stringHolders[i]);
        }
        if (len > 1 && (thresholdCount = this.thresholdCalculator.thresholdCountFor(wrappers)) > 1) {
            this.stripAffixes((StringHolderWrapper[])wrappers, thresholdCount);
        }
        return wrappers;
    }

    private StringHolderWrapper wrap(StringHolder stringHolder) {
        return this.wrapperFactory.buildStringHolderWrapper(stringHolder);
    }

    private void stripAffixes(StringHolderWrapper[] wrappers, int thresholdCount) {
        HashMap<Character, ArrayList<StringHolderWrapper>> charGroups = new HashMap<Character, ArrayList<StringHolderWrapper>>(100);
        int i = wrappers.length;
        while (i-- > 0) {
            StringHolderWrapper wrapper = wrappers[i];
            char c = wrapper.outsideChar();
            if (c == '\u0000') continue;
            Character bigC = new Character(c);
            ArrayList<StringHolderWrapper> group = (ArrayList<StringHolderWrapper>)charGroups.get(bigC);
            if (group == null) {
                group = new ArrayList<StringHolderWrapper>();
                charGroups.put(bigC, group);
            }
            group.add(wrapper);
        }
        for (Map.Entry entry : charGroups.entrySet()) {
            ArrayList group = (ArrayList)entry.getValue();
            if (group.size() < thresholdCount) continue;
            StringHolderWrapper[] groupArray = group.toArray(new StringHolderWrapper[group.size()]);
            int i2 = groupArray.length;
            while (i2-- > 0) {
                groupArray[i2].incrementAffixSize();
            }
            this.stripAffixes(groupArray, thresholdCount);
        }
    }

    private PartialStringComparatorEngine.StringHolderPair[] unwrap(PartialStringComparatorEngine.StringHolderPair[] stringHolderPairs) {
        PartialStringComparatorEngine.StringHolderPair[] result = new PartialStringComparatorEngine.StringHolderPair[stringHolderPairs.length];
        int i = stringHolderPairs.length;
        while (i-- > 0) {
            PartialStringComparatorEngine.StringHolderPair wrappedPair = stringHolderPairs[i];
            result[i] = new PartialStringComparatorEngine.SimpleStringHolderPair(this.unwrap(wrappedPair.getStringHolder1()), this.unwrap(wrappedPair.getStringHolder2()), wrappedPair.getScore());
        }
        return result;
    }

    private StringHolder unwrap(StringHolder stringHolder) {
        return stringHolder == null ? null : ((StringHolderWrapper)stringHolder).getStringHolder();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        StringTools.buildSimpleToStringOn(this, sb);
        sb.append(" (");
        this.wrapperFactory.toString(sb);
        sb.append(" : ");
        this.thresholdCalculator.toString(sb);
        sb.append(')');
        return sb.toString();
    }

    private static class StringHolderWrapper
    implements StringHolder {
        private final AffixPolicy affixPolicy;
        private final StringHolder stringHolder;
        private int stringHolderStringLength;
        private int affixLength;
        private String string;

        static StringHolderWrapper forPrefixStripping(StringHolder stringHolder) {
            return new StringHolderWrapper(stringHolder, AffixPolicy.PREFIX);
        }

        static StringHolderWrapper forSuffixStripping(StringHolder stringHolder) {
            return new StringHolderWrapper(stringHolder, AffixPolicy.SUFFIX);
        }

        private StringHolderWrapper(StringHolder stringHolder, AffixPolicy affixPolicy) {
            this.stringHolder = stringHolder;
            this.stringHolderStringLength = stringHolder.getString().length();
            this.affixPolicy = affixPolicy;
            this.affixLength = 0;
            this.string = null;
        }

        @Override
        public String getString() {
            if (this.string == null) {
                this.string = this.buildString();
            }
            return this.string;
        }

        private String buildString() {
            return this.affixPolicy.buildString(this.stringHolder.getString(), this.affixLength);
        }

        StringHolder getStringHolder() {
            return this.stringHolder;
        }

        char outsideChar() {
            return this.affixLength == this.stringHolderStringLength ? (char)'\u0000' : this.affixPolicy.outsideChar(this.stringHolder.getString(), this.affixLength);
        }

        void incrementAffixSize() {
            if (this.affixLength < this.stringHolderStringLength) {
                ++this.affixLength;
            }
        }

        public String toString() {
            return StringTools.buildToStringFor(this, this.buildString());
        }

        private static interface AffixPolicy {
            public static final AffixPolicy PREFIX = new AffixPolicy(){

                @Override
                public String buildString(String string, int affixLength) {
                    return string.substring(affixLength);
                }

                @Override
                public char outsideChar(String string, int affixLength) {
                    return string.charAt(affixLength);
                }
            };
            public static final AffixPolicy SUFFIX = new AffixPolicy(){

                @Override
                public String buildString(String string, int affixLength) {
                    return string.substring(0, string.length() - affixLength);
                }

                @Override
                public char outsideChar(String string, int affixLength) {
                    return string.charAt(string.length() - affixLength - 1);
                }
            };

            public String buildString(String var1, int var2);

            public char outsideChar(String var1, int var2);
        }
    }

    private static interface StringHolderWrapperFactory {
        public static final StringHolderWrapperFactory PREFIX = new StringHolderWrapperFactory(){

            @Override
            public StringHolderWrapper buildStringHolderWrapper(StringHolder stringHolder) {
                return StringHolderWrapper.forPrefixStripping(stringHolder);
            }

            @Override
            public void toString(StringBuffer sb) {
                sb.append("PREFIX");
            }
        };
        public static final StringHolderWrapperFactory SUFFIX = new StringHolderWrapperFactory(){

            @Override
            public StringHolderWrapper buildStringHolderWrapper(StringHolder stringHolder) {
                return StringHolderWrapper.forSuffixStripping(stringHolder);
            }

            @Override
            public void toString(StringBuffer sb) {
                sb.append("SUFFIX");
            }
        };

        public StringHolderWrapper buildStringHolderWrapper(StringHolder var1);

        public void toString(StringBuffer var1);
    }

    private class FixedThresholdCalculator
    implements ThresholdCalculator {
        private int count;

        FixedThresholdCalculator(int count) {
            if (count <= 1) {
                throw new IllegalArgumentException("valid range: count > 1");
            }
            this.count = count;
        }

        @Override
        public int thresholdCountFor(StringHolder[] stringHolders) {
            return this.count;
        }

        @Override
        public void toString(StringBuffer sb) {
            sb.append(this.count);
        }
    }

    private class VariableThresholdCalculator
    implements ThresholdCalculator {
        private float factor;

        VariableThresholdCalculator(float factor) {
            if (factor <= 0.0f || factor > 1.0f) {
                throw new IllegalArgumentException("valid range: 0.0 < factor <= 1.0");
            }
            this.factor = factor;
        }

        @Override
        public int thresholdCountFor(StringHolder[] stringHolders) {
            return (int)((float)stringHolders.length * this.factor);
        }

        @Override
        public void toString(StringBuffer sb) {
            sb.append(this.factor);
        }
    }

    private static interface ThresholdCalculator {
        public int thresholdCountFor(StringHolder[] var1);

        public void toString(StringBuffer var1);
    }
}

