/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.sourcegen;

import java.util.Calendar;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.tools.workbench.framework.Application;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.resources.StringRepository;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWAggregateMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWOneToOneMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassCodeGenPolicy;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

abstract class AbstractClassCodeGenPolicy
implements MWClassCodeGenPolicy {
    private ApplicationContext context;

    protected AbstractClassCodeGenPolicy(ApplicationContext context) {
        this.context = context;
    }

    public ClassDefinition classDefinition() {
        return this.getMWClass().classDefinition((MWClassCodeGenPolicy)this);
    }

    protected abstract MWClass getMWClass();

    public String classComment(MWClass mwClass) {
        String CR = StringTools.CR;
        Object[] arguments = new String[]{this.application().getFullProductNameAndVersionNumber(), Calendar.getInstance().getTime().toString()};
        String comment = " ###  " + this.stringRepository().getString("CLASS_COMMENT_FOR_CODE_GEN", arguments) + "  ###";
        if (mwClass.zeroArgumentConstructor() == null) {
            comment = comment + CR + CR + this.stringRepository().getString("CLASS_COMMENT_FOR_CODE_GEN_NO_ZERO_ARG_CONSTRUCTOR", StringTools.CR);
        }
        return comment;
    }

    public String emptyMethodBodyComment() {
        return this.stringRepository().getString("EMPTY_METHOD_BODY_COMMENT");
    }

    public String collectionImplementationClassNotDeterminedComment(MWClassAttribute attribute, MWClass concreteValueType) {
        return this.stringRepository().getString("CODE_GEN_COMMENT_FOR_COLLECTION_IMPLEMENTATION_CLASS_NOT_DETERMINED", new Object[]{attribute.getName(), concreteValueType.shortName()});
    }

    public String oneToOneMappingThatControlsWritingOfPrimaryKeyComment(MWOneToOneMapping mapping) {
        return this.stringRepository().getString("CODE_GEN_COMMENT_FOR_ONE_TO_ONE_MAPPING_THAT_CONTROLS_WRITING_OF_PRIMARY_KEY", new Object[]{mapping.getName(), StringTools.CR});
    }

    public String aggregateMappingDoesNotAllowNullImplementationClassNotDeterminedComment() {
        return this.stringRepository().getString("CODE_GEN_COMMENT_FOR_AGGREGATE_MAPPING_THAT_DOES_NOT_ALLOW_NULL_IMPLEMENTATION_CLASS_NOT_DETERMINED");
    }

    public String aggregateMappingDoesNotAllowNullComment(MWAggregateMapping mapping) {
        return this.stringRepository().getString("CODE_GEN_COMMENT_FOR_AGGREGATE_MAPPING_THAT_DOES_NOT_ALLOW_NULL", new Object[]{mapping.getName()});
    }

    protected StringRepository stringRepository() {
        return this.context.getResourceRepository();
    }

    protected Application application() {
        return this.context.getApplication();
    }
}

