/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.datatypes.ByteArrayType;
import org.eclipse.persistence.testing.models.jpa.datatypes.CharArrayType;
import org.eclipse.persistence.testing.models.jpa.datatypes.CharacterArrayType;
import org.eclipse.persistence.testing.models.jpa.datatypes.DataTypesTableCreator;
import org.eclipse.persistence.testing.models.jpa.datatypes.PrimitiveByteArrayType;
import org.eclipse.persistence.testing.models.jpa.datatypes.WrapperTypes;

public class NullBindingJUnitTestCase
extends JUnitTestCase {
    private static int wrapperId;
    private static int byteArrayId;
    private static int pByteArrayId;
    private static int characterArrayId;
    private static int pCharArrayId;

    public NullBindingJUnitTestCase() {
    }

    public NullBindingJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Null Binding DataTypes");
        suite.addTest((Test)new NullBindingJUnitTestCase("testSetup"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testCreateWrapperTypes"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyBigDecimal"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyBigInteger"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyBoolean"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyByte"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyCharacter"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyShort"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyInteger"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyLong"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyFloat"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyDouble"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testNullifyString"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testCreateByteArrayType"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testCreatePrimitiveByteArrayType"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testCreateCharacterArrayType"));
        suite.addTest((Test)new NullBindingJUnitTestCase("testCreateCharArrayType"));
        return suite;
    }

    public void testSetup() {
        new DataTypesTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testCreateWrapperTypes() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        WrapperTypes wt = new WrapperTypes(BigDecimal.ZERO, BigInteger.ZERO, Boolean.FALSE, new Byte("0"), Character.valueOf('A'), new Short("0"), Integer.valueOf(0), Long.valueOf(0L), new Float(0.0), Double.valueOf(0.0), "A String");
        em.persist((Object)wt);
        wrapperId = wt.getId();
        this.commitTransaction(em);
    }

    public void testNullifyBigDecimal() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setBigDecimalData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting BigDecimal field to null", (wt2.getBigDecimalData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyBigInteger() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setBigIntegerData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting BigInteger field to null", (wt2.getBigIntegerData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyBoolean() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setBooleanData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Boolean field to null", (wt2.getBooleanData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyByte() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setByteData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Byte field to null", (wt2.getByteData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyCharacter() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setCharacterData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Character field to null", (wt2.getCharacterData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyShort() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setShortData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Short field to null", (wt2.getShortData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyInteger() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setIntegerData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Integer field to null", (wt2.getIntegerData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyLong() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setLongData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Long field to null", (wt2.getLongData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyFloat() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setFloatData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Float field to null", (wt2.getFloatData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyDouble() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setDoubleData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Double field to null", (wt2.getDoubleData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testNullifyString() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            WrapperTypes wt = (WrapperTypes)em.find(WrapperTypes.class, (Object)wrapperId);
            wt.setStringData(null);
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT wt FROM WrapperTypes wt WHERE wt.id = " + wrapperId);
            WrapperTypes wt2 = (WrapperTypes)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting String field to null", (wt2.getStringData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCreateByteArrayType() {
        EntityManager em = this.createEntityManager();
        if (JUnitTestCase.getServerSession().getPlatform().isDerby()) {
            NullBindingJUnitTestCase.warning((String)"Warning: Derby does not support setting a BLOB to null. For details, see https://bugs.eclipse.org/bugs/show_bug.cgi?id=296293");
            return;
        }
        try {
            this.beginTransaction(em);
            ByteArrayType bat = new ByteArrayType();
            em.persist((Object)bat);
            byteArrayId = bat.getId();
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT bat FROM ByteArrayType bat WHERE bat.id = " + byteArrayId);
            ByteArrayType bat2 = (ByteArrayType)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Byte[] field to null", (bat2.getByteArrayData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCreatePrimitiveByteArrayType() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            PrimitiveByteArrayType pbat = new PrimitiveByteArrayType();
            em.persist((Object)pbat);
            pByteArrayId = pbat.getId();
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT pbat FROM PrimitiveByteArrayType pbat WHERE pbat.id = " + pByteArrayId);
            PrimitiveByteArrayType pbat2 = (PrimitiveByteArrayType)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting byte[] field to null", (pbat2.getPrimitiveByteArrayData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCreateCharacterArrayType() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            CharacterArrayType cat = new CharacterArrayType();
            em.persist((Object)cat);
            characterArrayId = cat.getId();
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT cat FROM CharacterArrayType cat WHERE cat.id = " + characterArrayId);
            CharacterArrayType cat2 = (CharacterArrayType)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting Character[] field to null", (cat2.getCharacterArrayData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testCreateCharArrayType() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            CharArrayType pcat = new CharArrayType();
            em.persist((Object)pcat);
            pCharArrayId = pcat.getId();
            this.commitTransaction(em);
            Query q = em.createQuery("SELECT pcat FROM CharArrayType pcat WHERE pcat.id = " + pCharArrayId);
            CharArrayType pcat2 = (CharArrayType)q.getSingleResult();
            NullBindingJUnitTestCase.assertTrue((String)"Error setting char[] field to null", (pcat2.getPrimitiveCharArrayData() == null ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }
}

