/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.resources;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.eclipse.persistence.tools.workbench.framework.resources.IconRepository;
import org.eclipse.persistence.tools.workbench.framework.resources.IconResourceFileNameMap;
import org.eclipse.persistence.tools.workbench.framework.resources.MissingIconException;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class DefaultIconRepository
implements IconRepository {
    private IconResourceFileNameMap resourceFileNames;
    private final Map cache;

    public DefaultIconRepository() {
        this(IconResourceFileNameMap.NULL_INSTANCE);
    }

    public DefaultIconRepository(IconResourceFileNameMap resourceFileNames) {
        if (resourceFileNames == null) {
            throw new NullPointerException();
        }
        this.resourceFileNames = resourceFileNames;
        this.cache = new HashMap();
    }

    @Override
    public boolean hasIcon(String key) {
        return key == null || this.cache.containsKey(key) || this.canLoadIcon(key);
    }

    @Override
    public synchronized Icon getIcon(String key) {
        if (key == null) {
            return null;
        }
        Icon icon = (Icon)this.cache.get(key);
        if (icon != null) {
            return icon;
        }
        icon = this.loadIcon(key);
        this.cache.put(key, icon);
        return icon;
    }

    protected Icon loadIcon(String key) {
        String resourceFileName = this.getResourceFileNames().getResourceFileName(key);
        URL url = this.getClass().getClassLoader().getResource(resourceFileName);
        if (url == null) {
            throw new MissingIconException("Missing icon file: " + key + " => " + resourceFileName, key);
        }
        return new ImageIcon(url);
    }

    protected boolean canLoadIcon(String key) {
        if (!this.getResourceFileNames().hasResourceFileName(key)) {
            return false;
        }
        String resourceFileName = this.getResourceFileNames().getResourceFileName(key);
        return this.getClass().getClassLoader().getResource(resourceFileName) != null;
    }

    protected IconResourceFileNameMap getResourceFileNames() {
        return this.resourceFileNames;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this);
    }
}

