/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.DefaultListChooserDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.ManyToManySourceReferencePanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.ManyToManyTargetReferencePanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.relational.RelationalProjectComponentFactory;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.chooser.ListChooser;
import org.eclipse.persistence.tools.workbench.utility.string.StringConverter;

final class ManyToManyTableReferencePropertiesPage
extends ScrollablePropertiesPage {
    ManyToManyTableReferencePropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        super(nodeHolder, contextHolder);
    }

    @Override
    protected Component buildPage() {
        GridBagConstraints constraints = new GridBagConstraints();
        Insets insets = BorderFactory.createTitledBorder("m").getBorderInsets(this);
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JComponent relationTableWidgets = this.buildLabeledComponent("MANY_TO_MANY_RELATION_TABLE_CHOOSER", this.buildRelationTableChooser());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, insets.left + 5, 0, insets.right + 5);
        this.addHelpTopicId(relationTableWidgets, "mapping.manyToMany.relationTable");
        container.add((Component)relationTableWidgets, constraints);
        ManyToManySourceReferencePanel sourceReference = new ManyToManySourceReferencePanel(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        sourceReference.setBorder(new CompoundBorder(this.buildTitledBorder("MANY_TO_MANY_TABLE_REFERENCE_SOURCE_TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)sourceReference, constraints);
        this.addPaneForAlignment(sourceReference);
        ManyToManyTargetReferencePanel targetReference = new ManyToManyTargetReferencePanel(this.getSelectionHolder(), this.getWorkbenchContextHolder());
        targetReference.setBorder(new CompoundBorder(this.buildTitledBorder("MANY_TO_MANY_TABLE_REFERENCE_TARGET_TITLE"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)targetReference, constraints);
        this.addPaneForAlignment(targetReference);
        return container;
    }

    private ListChooser buildRelationTableChooser() {
        return RelationalProjectComponentFactory.buildTableChooser(this.getSelectionHolder(), this.buildRelationTableHolder(), this.buildRelationTableChooserDialogBuilder(), this.getWorkbenchContextHolder());
    }

    private DefaultListChooserDialog.Builder buildRelationTableChooserDialogBuilder() {
        DefaultListChooserDialog.Builder builder = new DefaultListChooserDialog.Builder();
        builder.setTitleKey("RELATION_TABLE_LIST_BROWSER_DIALOG.title");
        builder.setListBoxLabelKey("RELATION_TABLE_LIST_BROWSER_DIALOG.listLabel");
        builder.setStringConverter(this.buildTableStringConverter());
        return builder;
    }

    private StringConverter buildTableStringConverter() {
        return new StringConverter(){

            public String convertToString(Object o) {
                return o == null ? "" : ((MWTable)o).getName();
            }
        };
    }

    private PropertyValueModel buildRelationTableHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder(), "relationTable"){

            @Override
            protected Object getValueFromSubject() {
                MWManyToManyMapping mapping = (MWManyToManyMapping)this.subject;
                return mapping.getRelationTable();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                MWManyToManyMapping mapping = (MWManyToManyMapping)this.subject;
                mapping.setRelationTable((MWTable)value);
            }
        };
    }
}

