/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cache;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class InsertOverflowTest
extends AutoVerifyTestCase {
    CacheIdentityMap cache;
    int originalMaxSize;

    public InsertOverflowTest(CacheIdentityMap cache) {
        this.cache = cache;
        this.originalMaxSize = cache.getMaxSize();
    }

    public void test() {
        for (int index = 0; index < this.originalMaxSize * 10; ++index) {
            Employee employee = new Employee();
            BigDecimal id = new BigDecimal((double)index * 101.0);
            Vector<BigDecimal> primaryKeys = new Vector<BigDecimal>();
            employee.setId(id);
            employee.setFirstName("Mr. " + id);
            primaryKeys.addElement(id);
            this.cache.put(primaryKeys, (Object)employee, null, 0L);
        }
    }

    public void verify() {
        if (this.cache.getSize() != this.originalMaxSize) {
            throw new TestErrorException("Cache identity map " + this.cache + " contains " + this.cache.getSize() + " objects.  " + "The specified maximum size for this cache was " + this.originalMaxSize + ".");
        }
        for (int index = this.originalMaxSize * 10 - this.originalMaxSize; index < this.originalMaxSize * 10; ++index) {
            BigDecimal id = new BigDecimal((double)index * 101.0);
            Vector<BigDecimal> primaryKeys = new Vector<BigDecimal>();
            primaryKeys.addElement(id);
            if (this.cache.containsKey(primaryKeys)) continue;
            throw new TestErrorException("Cache should contain value with keys " + primaryKeys + " but does not.");
        }
    }
}

