/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentAddress;

public class ConcurrentReadOnInsertTest
extends AutoVerifyTestCase {
    public static ConcurrentAddress readAddress;
    protected ConcurrentAddress addressClone;
    public static int depth;

    public void setup() {
        if (this.getSession().isDistributedSession()) {
            throw new TestWarningException("Test unavailable on Remote UnitOfWork.");
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ConcurrentAddress address = new ConcurrentAddress();
        address.setCity("Toronto");
        address.setPostalCode("L5J2B5");
        address.setProvince("ONT");
        address.setStreet("1450 Acme Cr., suite 4");
        address.setCountry("Canada");
        Thread thread = new Thread(this.runnable());
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.addressClone = (ConcurrentAddress)uow.registerObject((Object)address);
        readAddress = new ConcurrentAddress();
        try {
            ConcurrentAddress concurrentAddress = readAddress;
            synchronized (concurrentAddress) {
                depth = 1;
                thread.start();
                readAddress.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        uow.commit();
        try {
            thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (address != readAddress) {
            throw new TestErrorException(" The object returned from the Cache and the object merged into the cache are of different identity. see bug 2632705");
        }
    }

    public Runnable runnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ConcurrentAddress concurrentAddress = readAddress;
                    synchronized (concurrentAddress) {
                        readAddress.notifyAll();
                        readAddress.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                readAddress = (ConcurrentAddress)ConcurrentReadOnInsertTest.this.getSession().readObject((Object)ConcurrentReadOnInsertTest.this.addressClone);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            UnitOfWork unitOfWork = this.getSession().acquireUnitOfWork();
            unitOfWork.deleteObject((Object)readAddress);
            unitOfWork.commit();
        }
        finally {
            readAddress = null;
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

