/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ModifierComponentGroup;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;

final class ClassAttributeModifiersPanel
extends AbstractSubjectPanel {
    private ValueModel descriptorHolder;

    ClassAttributeModifiersPanel(ValueModel attributeHolder, ValueModel descriptorHolder, WorkbenchContextHolder contextHolder) {
        super(attributeHolder, contextHolder);
        this.descriptorHolder = descriptorHolder;
    }

    @Override
    protected void initializeLayout() {
        this.setBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("MODIFIER_PANEL_TITLE")));
        GridBagConstraints constraints = new GridBagConstraints();
        ModifierComponentGroup modifierComponentGroup = new ModifierComponentGroup(this.buildVerifier(), this.getSubjectHolder(), this.getApplicationContext());
        JPanel accessModifiersPanel = modifierComponentGroup.getAccessModifiersPanel();
        accessModifiersPanel.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.3;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        accessModifiersPanel.add((Component)modifierComponentGroup.getPublicAccessRadioButton(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.3;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 0);
        accessModifiersPanel.add((Component)modifierComponentGroup.getProtectedAccessRadioButton(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 5);
        accessModifiersPanel.add((Component)modifierComponentGroup.getPrivateAccessRadioButton(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 5);
        accessModifiersPanel.add((Component)modifierComponentGroup.getDefaultAccessRadioButton(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.3;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 5, 5, 0);
        this.add((Component)accessModifiersPanel, constraints);
        JPanel otherModifiersPanel = modifierComponentGroup.getOtherModifiersPanel();
        otherModifiersPanel.setLayout(new GridBagLayout());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.3;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        otherModifiersPanel.add((Component)modifierComponentGroup.getFinalCheckBox(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.3;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 0);
        otherModifiersPanel.add((Component)modifierComponentGroup.getStaticCheckBox(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 5);
        otherModifiersPanel.add((Component)modifierComponentGroup.getTransientCheckBox(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 5, 5);
        otherModifiersPanel.add((Component)modifierComponentGroup.getVolatileCheckBox(), constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 11;
        constraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)otherModifiersPanel, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes.general.modifiers";
    }

    private ModifierComponentGroup.Verifier buildVerifier() {
        return new ModifierComponentGroup.Verifier(){

            @Override
            public boolean verifyFinalChange(boolean newModifierIsFinal) {
                return ClassAttributeModifiersPanel.this.verifyFinalOrStaticChange(newModifierIsFinal);
            }

            @Override
            public boolean verifyStaticChange(boolean newModifierIsStatic) {
                return ClassAttributeModifiersPanel.this.verifyFinalOrStaticChange(newModifierIsStatic);
            }
        };
    }

    boolean verifyFinalOrStaticChange(boolean newModifierIsFinalOrStatic) {
        if (!newModifierIsFinalOrStatic) {
            return true;
        }
        if (this.attribute().getModifier().isStatic() || this.attribute().getModifier().isFinal()) {
            return true;
        }
        boolean result = this.promptToChangeStaticOrFinalModifier();
        if (this.descriptor().mappingForAttribute(this.attribute()) != null) {
            this.descriptor().removeMappingForAttribute(this.attribute());
        }
        return result;
    }

    private MWClassAttribute attribute() {
        return (MWClassAttribute)this.subject();
    }

    private boolean promptToChangeStaticOrFinalModifier() {
        int result = JOptionPane.showConfirmDialog(this.currentWindow(), new LabelArea(this.resourceRepository().getString("sTATICAndFINALAttributesCannot")), this.resourceRepository().getString("removeMapping?"), 2, 1);
        return result == 0;
    }

    private MWMappingDescriptor descriptor() {
        return (MWMappingDescriptor)this.descriptorHolder.getValue();
    }
}

