/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class AddArgumentDialog
extends NewNameDialog {
    private PropertyValueModel argumentTypeHolder;
    private PropertyValueModel passTypeHolder;

    protected AddArgumentDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
        super(workbenchContext, builder);
    }

    @Override
    protected AddArgumentBuilder builder() {
        return (AddArgumentBuilder)super.builder();
    }

    @Override
    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        JLabel descriptionPanel = new JLabel(this.resourceRepository().getString("ADD_ARGUMENT_DIALOG_DESCRIPTION"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)descriptionPanel, constraints);
        JComponent newNameWidget = this.buildNewNameWidgets();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)newNameWidget, constraints);
        Component customPane = this.buildCustomPane();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add(customPane, constraints);
        return container;
    }

    protected JComponent buildNewNameWidgets() {
        Document document = this.buildDocumentWithStateObject();
        document.addDocumentListener(this.buildDocumentListener());
        this.textField = new JTextField(20);
        JComponent component = this.buildLabeledTextField("ENTER_NEW_ARGUMENT_NAME", document, this.textField);
        component.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        new ComponentEnabler((ValueModel)this.buildIsNamedHolder(), component);
        return component;
    }

    protected Component buildCustomPane() {
        Pane container = new Pane(new BorderLayout());
        container.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        container.add((Component)this.buildArgumentTypePane(), "First");
        container.add((Component)this.buildPassTypePane(), "Last");
        return container;
    }

    private PropertyValueModel buildArgumentTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "argumentType"){

            @Override
            protected Object getValueFromSubject() {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                return stateObject.getArgumentType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                stateObject.setArgumentType((ArgumentType)((Object)value));
                if (stateObject.isNamed()) {
                    AddArgumentDialog.this.getOKAction().setEnabled(AddArgumentDialog.this.getNameInternal().length() > 0);
                } else {
                    AddArgumentDialog.this.clearErrorMessage();
                }
            }
        };
    }

    private PropertyValueModel buildPassTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "argumentPassType"){

            @Override
            protected Object getValueFromSubject() {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                return stateObject.getArgumentPassType();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                stateObject.setArgumentPassType((ArgumentPassType)((Object)value));
            }
        };
    }

    private PropertyValueModel buildSupportsValueHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "supportsValue"){

            @Override
            protected Object getValueFromSubject() {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                return new Boolean(stateObject.supportsValue());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                stateObject.setSupportsValue((Boolean)value);
            }
        };
    }

    private PropertyValueModel buildIsNamedHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "isNamed"){

            @Override
            protected Object getValueFromSubject() {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                return new Boolean(stateObject.isNamed());
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ArgumentStateObject stateObject = (ArgumentStateObject)((Object)this.subject);
                stateObject.setIsNamed((Boolean)value);
            }
        };
    }

    @Override
    protected ArgumentStateObject buildStateObject() {
        return new ArgumentStateObject(this.builder());
    }

    ArgumentType getArgumentType() {
        return ((ArgumentStateObject)this.subject()).getArgumentType();
    }

    ArgumentPassType getArgumentPassType() {
        return ((ArgumentStateObject)this.subject()).getArgumentPassType();
    }

    boolean isOutType() {
        return ((ArgumentStateObject)this.subject()).supportsValue();
    }

    @Override
    protected String helpTopicId() {
        return "descriptor.queryManager.procedures.arguments";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("ADD_ARGUMENT_DIALOG_TITLE"));
        this.getOKAction().setEnabled(false);
    }

    protected final JComponent buildArgumentTypePane() {
        GridBagConstraints constraints = new GridBagConstraints();
        ArrayList<JRadioButton> components = new ArrayList<JRadioButton>(6);
        this.argumentTypeHolder = this.buildArgumentTypeHolder();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(this.buildTitledBorder("TYPE_BORDER_LABEL_ON_ADD_ARGUMENT_DIALOG"));
        JRadioButton namedInArgumentRadioButton = this.buildRadioButton("NAMED_IN_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildNamedInArgumentRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)namedInArgumentRadioButton, constraints);
        components.add(namedInArgumentRadioButton);
        JRadioButton namedOutRadioButton = this.buildRadioButton("NAMED_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildNamedOutArgumentRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)namedOutRadioButton, constraints);
        components.add(namedOutRadioButton);
        JRadioButton namedInOutRadioButton = this.buildRadioButton("NAMED_IN_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildNamedInOutArgumentRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)namedInOutRadioButton, constraints);
        components.add(namedInOutRadioButton);
        JRadioButton unnamedInArgumentRadioButton = this.buildRadioButton("UNNAMED_IN_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildUnNamedInArgumentRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)unnamedInArgumentRadioButton, constraints);
        components.add(unnamedInArgumentRadioButton);
        JRadioButton unnamedOutRadioButton = this.buildRadioButton("UNNAMED_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildUnNamedOutArgumentRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)unnamedOutRadioButton, constraints);
        components.add(unnamedOutRadioButton);
        JRadioButton unnamedInOutRadioButton = this.buildRadioButton("UNNAMED_IN_OUT_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildUnNamedInOutArgumentRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)unnamedInOutRadioButton, constraints);
        components.add(unnamedInOutRadioButton);
        this.helpManager().addTopicID(container, this.helpTopicId() + ".type");
        return container;
    }

    private ButtonModel buildNamedInArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.NAMED_IN);
    }

    private ButtonModel buildNamedInOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.NAMED_IN_OUT);
    }

    private ButtonModel buildNamedOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.NAMED_OUT);
    }

    private ButtonModel buildUnNamedInArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.UNNAMED_IN);
    }

    private ButtonModel buildUnNamedInOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.UNNAMED_IN_OUT);
    }

    private ButtonModel buildUnNamedOutArgumentRadioButtonModel() {
        return new RadioButtonModelAdapter(this.argumentTypeHolder, (Object)ArgumentType.UNNAMED_OUT);
    }

    protected final JComponent buildPassTypePane() {
        GridBagConstraints constraints = new GridBagConstraints();
        ArrayList<JRadioButton> components = new ArrayList<JRadioButton>(2);
        this.passTypeHolder = this.buildPassTypeHolder();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(this.buildTitledBorder("PASS_TYPE_BORDER_LABEL_ON_ADD_ARGUMENT_DIALOG"));
        JRadioButton parameterRadioButton = this.buildRadioButton("PARAMETER_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildParameterPassTypeRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)parameterRadioButton, constraints);
        components.add(parameterRadioButton);
        JRadioButton valueRadioButton = this.buildRadioButton("VALUE_RADIOBUTTON_ON_ADD_ARGUMENT_DIALOG", this.buildValuePassTypeRadioButtonModel());
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)valueRadioButton, constraints);
        components.add(valueRadioButton);
        new ComponentEnabler((ValueModel)this.buildSupportsValueHolder(), components);
        this.helpManager().addTopicID(container, this.helpTopicId() + ".passType");
        return container;
    }

    private ButtonModel buildParameterPassTypeRadioButtonModel() {
        return new RadioButtonModelAdapter(this.passTypeHolder, (Object)ArgumentPassType.PARAMETER);
    }

    private ButtonModel buildValuePassTypeRadioButtonModel() {
        return new RadioButtonModelAdapter(this.passTypeHolder, (Object)ArgumentPassType.VALUE);
    }

    static enum ArgumentPassType {
        PARAMETER,
        VALUE;

    }

    static enum ArgumentType {
        NAMED_IN,
        NAMED_OUT,
        NAMED_IN_OUT,
        UNNAMED_IN,
        UNNAMED_OUT,
        UNNAMED_IN_OUT;

    }

    class ArgumentStateObject
    extends NewNameDialog.StateObject {
        private ArgumentType argumentType;
        public static final String ARGUMENT_TYPE_PROPERTY = "argumentType";
        private ArgumentPassType argumentPassType;
        public static final String ARGUMENT_PASS_TYPE_PROPERTY = "argumentPassType";
        private boolean supportsValue;
        public static final String SUPPORTS_VALUE = "supportsValue";
        private boolean isNamed;
        public static final String IS_NAMED = "isNamed";

        ArgumentStateObject(NewNameDialog.Builder builder) {
            super(builder);
            this.argumentType = ArgumentType.NAMED_IN;
            this.argumentPassType = ArgumentPassType.PARAMETER;
            this.supportsValue = true;
            this.isNamed = true;
        }

        @Override
        protected void editName(List<Problem> currentProblems) {
            String text = this.getName();
            if (this.getArgumentType() != ArgumentType.UNNAMED_IN && this.getArgumentType() != ArgumentType.UNNAMED_IN_OUT && this.getArgumentType() != ArgumentType.UNNAMED_OUT && StringTools.stringIsEmpty((String)text)) {
                currentProblems.add(this.buildProblem("NEW_NAME_DIALOG.EMPTY_VALUE"));
                return;
            }
            AddArgumentDialog.this.clearErrorMessage();
        }

        public ArgumentType getArgumentType() {
            return this.argumentType;
        }

        public void setArgumentType(ArgumentType argumentType) {
            ArgumentType oldArgumentType = this.argumentType;
            this.argumentType = argumentType;
            this.firePropertyChanged(ARGUMENT_TYPE_PROPERTY, (Object)oldArgumentType, (Object)argumentType);
            if (this.argumentType == ArgumentType.NAMED_IN || this.argumentType == ArgumentType.NAMED_IN_OUT || this.argumentType == ArgumentType.UNNAMED_IN || this.argumentType == ArgumentType.UNNAMED_IN_OUT) {
                this.setSupportsValue(true);
            } else {
                this.setSupportsValue(false);
            }
            if (this.argumentType == ArgumentType.NAMED_IN || this.argumentType == ArgumentType.NAMED_IN_OUT || this.argumentType == ArgumentType.NAMED_OUT) {
                this.setIsNamed(true);
            } else {
                this.setIsNamed(false);
            }
        }

        public ArgumentPassType getArgumentPassType() {
            return this.argumentPassType;
        }

        public void setArgumentPassType(ArgumentPassType argumentPassType) {
            ArgumentPassType oldArgumentPassType = this.argumentPassType;
            this.argumentPassType = argumentPassType;
            this.firePropertyChanged(ARGUMENT_PASS_TYPE_PROPERTY, (Object)oldArgumentPassType, (Object)argumentPassType);
        }

        public boolean supportsValue() {
            return this.supportsValue;
        }

        public void setSupportsValue(boolean newValue) {
            boolean oldValue = this.supportsValue;
            this.supportsValue = newValue;
            this.firePropertyChanged(SUPPORTS_VALUE, oldValue, newValue);
        }

        public boolean isNamed() {
            return this.isNamed;
        }

        public void setIsNamed(boolean newValue) {
            boolean oldValue = this.isNamed;
            this.isNamed = newValue;
            this.firePropertyChanged(IS_NAMED, oldValue, newValue);
        }
    }

    static class AddArgumentBuilder
    extends NewNameDialog.Builder {
        AddArgumentBuilder() {
        }

        @Override
        public AddArgumentDialog buildDialog(WorkbenchContext context) {
            return (AddArgumentDialog)super.buildDialog(context);
        }

        @Override
        protected AddArgumentDialog buildDialog(WorkbenchContext context, NewNameDialog.Builder clone) {
            return new AddArgumentDialog(context, clone);
        }
    }
}

