/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public class ItemListListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] listNames;
    protected ListChangeListener itemListListener;

    public ItemListListValueModelAdapter(ListValueModel listHolder, String listName) {
        this(listHolder, new String[]{listName});
    }

    public ItemListListValueModelAdapter(ListValueModel listHolder, String listName1, String listName2) {
        this(listHolder, new String[]{listName1, listName2});
    }

    public ItemListListValueModelAdapter(ListValueModel listHolder, String listName1, String listName2, String listName3) {
        this(listHolder, new String[]{listName1, listName2, listName3});
    }

    public ItemListListValueModelAdapter(ListValueModel listHolder, String[] listNames) {
        super(listHolder);
        this.listNames = listNames;
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String listName) {
        this(collectionHolder, new String[]{listName});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String listName1, String listName2) {
        this(collectionHolder, new String[]{listName1, listName2});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String listName1, String listName2, String listName3) {
        this(collectionHolder, new String[]{listName1, listName2, listName3});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionHolder, String[] listNames) {
        super(collectionHolder);
        this.listNames = listNames;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.itemListListener = this.buildItemListListener();
    }

    protected ListChangeListener buildItemListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public void itemsRemoved(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public void itemsReplaced(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public void listChanged(ListChangeEvent e) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)e);
            }

            public String toString() {
                return "item list listener: " + Arrays.asList(ItemListListValueModelAdapter.this.listNames);
            }
        };
    }

    @Override
    protected void startListeningToItem(Model item) {
        int i = this.listNames.length;
        while (i-- > 0) {
            item.addListChangeListener(this.listNames[i], this.itemListListener);
        }
    }

    @Override
    protected void stopListeningToItem(Model item) {
        int i = this.listNames.length;
        while (i-- > 0) {
            item.removeListChangeListener(this.listNames[i], this.itemListListener);
        }
    }
}

