/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.proxyindirection;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.proxyindirection.Address;
import org.eclipse.persistence.testing.tests.proxyindirection.Employee;

public class DeleteProxyObjectTest
extends AutoVerifyTestCase {
    Object address;

    public DeleteProxyObjectTest() {
        this.setDescription("Tests deleting proxy object with Proxy Indirection.");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").like("%Rick%"));
        this.address = emp.getAddress();
        UnitOfWorkImpl uow = (UnitOfWorkImpl)this.getSession().acquireUnitOfWork();
        Employee aClone = (Employee)uow.registerObject((Object)emp);
        aClone.setAddress(null);
        uow.deleteObject(this.address);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Employee emp = (Employee)this.getSession().readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Rick"));
        if (emp.getAddress() != null) {
            throw new TestErrorException("Employee's address is not set to null.");
        }
        Address add = (Address)this.getSession().readObject(this.address);
        if (add != null) {
            throw new TestErrorException("Address was not deleted.");
        }
    }
}

