/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWTableHandle
extends MWHandle {
    private volatile MWTable table;
    private volatile String tableName;

    private MWTableHandle() {
    }

    public MWTableHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWTableHandle(MWModel parent, MWTable table, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.table = table;
    }

    public MWTable getTable() {
        return this.table;
    }

    public void setTable(MWTable table) {
        this.table = table;
    }

    @Override
    protected Node node() {
        return this.getTable();
    }

    public MWTableHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void resolveMetadataHandles() {
        super.resolveMetadataHandles();
        if (this.tableName != null) {
            this.table = this.getDatabase().tableNamed(this.tableName);
        }
        this.tableName = null;
    }

    public int compareTo(Object o) {
        return this.table.compareTo(((MWTableHandle)o).table);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.table == null) {
            sb.append("null");
        } else {
            this.table.toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWTableHandle.class);
        descriptor.addDirectMapping("tableName", "getTableNameForToplink", "setTableNameForToplink", "table-name/text()");
        return descriptor;
    }

    private String getTableNameForToplink() {
        return this.table == null ? null : this.table.getName();
    }

    private void setTableNameForToplink(String tableName) {
        this.tableName = tableName;
    }
}

