/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping;

import java.text.Collator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWConverterMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConverter;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWObjectTypeConverter
extends MWTypeConverter {
    private Collection valuePairs;
    public static final String VALUE_PAIRS_COLLECTION = "valuePairs";
    private volatile ValuePair defaultValuePair;
    public static final String DEFAULT_ATTRIBUTE_VALUE_PROPERTY = "defaultAttributeProperty";

    private MWObjectTypeConverter() {
    }

    public MWObjectTypeConverter(MWConverterMapping parent) {
        super(parent);
    }

    public MWObjectTypeConverter(MWConverterMapping parent, Map legacyValueMap) {
        super(parent, legacyValueMap);
    }

    @Override
    protected void initialize(Node parent) {
        super.initialize(parent);
        this.valuePairs = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.valuePairs;
        synchronized (collection) {
            children.addAll(this.valuePairs);
        }
    }

    public Iterator valuePairs() {
        return new CloneIterator(this.valuePairs);
    }

    public int valuePairsSize() {
        return this.valuePairs.size();
    }

    public void addValuePair(String dataValueString, String attributeValueString) throws ConversionValueException, ConversionException {
        Object attributeValue = this.buildAttributeValue(attributeValueString);
        Object dataValue = this.buildDataValue(dataValueString);
        this.addValuePair(dataValue, attributeValue);
    }

    public ValuePair addValuePair(Object dataValue, Object attributeValue) throws ConversionValueException {
        if (this.duplicateDataValue(dataValue)) {
            throw ConversionValueException.duplicateDataValueException(dataValue);
        }
        if (this.duplicateAttributeValue(attributeValue)) {
            throw ConversionValueException.duplicateAttributeValueException(attributeValue);
        }
        ValuePair valuePair = new ValuePair(this, dataValue, attributeValue);
        this.addValuePairInternal(valuePair);
        return valuePair;
    }

    public void editValuePair(ValuePair valuePair, String dataValueString, String attributeValueString) throws ConversionValueException, ConversionException {
        Object dataValue = this.buildDataValue(dataValueString);
        Object attributeValue = this.buildAttributeValue(attributeValueString);
        if (!valuePair.dataValue.equals(dataValue) && this.duplicateDataValue(dataValue)) {
            throw ConversionValueException.duplicateDataValueException(dataValue);
        }
        if (!valuePair.attributeValue.equals(attributeValue) && this.duplicateAttributeValue(attributeValue)) {
            throw ConversionValueException.duplicateAttributeValueException(attributeValue);
        }
        valuePair.setDataValue(dataValue);
        valuePair.setAttributeValue(attributeValue);
    }

    public void removeValuePair(ValuePair valuePair) {
        this.valuePairs.remove(valuePair);
        this.fireItemRemoved(VALUE_PAIRS_COLLECTION, valuePair);
        if (this.defaultValuePair == valuePair) {
            this.setDefaultValuePair(null);
        }
    }

    public void clearValuePairs() {
        this.valuePairs.clear();
        this.fireCollectionChanged(VALUE_PAIRS_COLLECTION);
        this.setDefaultValuePair(null);
    }

    public Object getDefaultAttributeValue() {
        return this.defaultValuePair == null ? null : this.defaultValuePair.attributeValue;
    }

    public void setDefaultAttributeValue(Object defaultAttributeValue) {
        this.setDefaultValuePair(this.valuePairForAttributeValue(defaultAttributeValue));
    }

    public void setDefaultAttributeValue(String newDefaultAttributeValueString) throws ConversionException {
        this.setDefaultAttributeValue(this.buildAttributeValue(newDefaultAttributeValueString));
    }

    @Override
    public String accessibleNameKey() {
        return "ACCESSIBLE_SERIALIZED_MAPPING_NODE";
    }

    @Override
    public String getType() {
        return "object-type-converter";
    }

    @Override
    public String iconKey() {
        return "mapping.objectType";
    }

    private Iterator dataValues() {
        return new TransformationIterator(this.valuePairs()){

            @Override
            protected Object transform(Object next) {
                return ((ValuePair)next).dataValue;
            }
        };
    }

    private Iterator attributeValues() {
        return new TransformationIterator(this.valuePairs()){

            @Override
            protected Object transform(Object next) {
                return ((ValuePair)next).attributeValue;
            }
        };
    }

    private void addValuePairInternal(ValuePair valuePair) {
        this.valuePairs.add(valuePair);
        this.fireItemAdded(VALUE_PAIRS_COLLECTION, valuePair);
    }

    @Override
    protected void rebuildValuePairs() {
        Iterator valuePairsCopy = this.valuePairs();
        this.clearValuePairs();
        if (this.getDataType() == null || this.getAttributeType() == null) {
            return;
        }
        Iterator stream = valuePairsCopy;
        while (stream.hasNext()) {
            ValuePair nextPair = (ValuePair)stream.next();
            ValuePair valuePair = null;
            try {
                valuePair = this.addValuePair(this.buildDataValue(nextPair.dataValue), this.buildAttributeValue(nextPair.attributeValue));
            }
            catch (ConversionException conversionException) {
            }
            catch (ConversionValueException conversionValueException) {
                // empty catch block
            }
            if (this.defaultValuePair != nextPair) continue;
            this.setDefaultValuePair(valuePair);
        }
    }

    private boolean duplicateDataValue(Object dataValue) {
        Iterator stream = this.dataValues();
        while (stream.hasNext()) {
            if (!stream.next().equals(dataValue)) continue;
            return true;
        }
        return false;
    }

    private boolean duplicateAttributeValue(Object attributeValue) {
        Iterator stream = this.attributeValues();
        while (stream.hasNext()) {
            if (!stream.next().equals(attributeValue)) continue;
            return true;
        }
        return false;
    }

    private ValuePair valuePairForAttributeValue(Object attributeValue) {
        Iterator stream = this.valuePairs();
        while (stream.hasNext()) {
            ValuePair valuePair = (ValuePair)stream.next();
            if (!valuePair.attributeValue.equals(attributeValue)) continue;
            return valuePair;
        }
        if (attributeValue == null) {
            return null;
        }
        throw new IllegalArgumentException(String.valueOf(attributeValue));
    }

    private void setDefaultValuePair(ValuePair newDefaultValuePair) {
        Object oldDefaultAttributeValue = this.defaultValuePair == null ? null : this.defaultValuePair.attributeValue;
        this.defaultValuePair = newDefaultValuePair;
        Object newDefaultAttributeValue = this.defaultValuePair == null ? null : this.defaultValuePair.attributeValue;
        this.firePropertyChanged(DEFAULT_ATTRIBUTE_VALUE_PROPERTY, oldDefaultAttributeValue, newDefaultAttributeValue);
    }

    private Object buildAttributeValue(Object oldAttributeValue) throws ConversionException {
        Class javaClass = null;
        try {
            javaClass = ClassTools.classForTypeDeclaration(this.getAttributeType().typeName(), this.getAttributeType().getDimensionality());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return ConversionManager.getDefaultManager().convertObject(oldAttributeValue, javaClass);
    }

    private Object buildDataValue(Object oldDataValue) throws ConversionException {
        Class javaClass = null;
        try {
            javaClass = ClassTools.classForTypeDeclaration(this.getDataType().typeName(), this.getDataType().getDimensionality());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return ConversionManager.getDefaultManager().convertObject(oldDataValue, javaClass);
    }

    @Override
    protected void addProblemsTo(List currentProblems) {
        super.addProblemsTo(currentProblems);
        this.checkValuePairs(currentProblems);
    }

    private void checkValuePairs(List currentProblems) {
        if (this.valuePairsSize() == 0) {
            currentProblems.add(this.buildProblem("0542"));
        }
    }

    @Override
    public Converter runtimeConverter(DatabaseMapping mapping) {
        ObjectTypeConverter converter = new ObjectTypeConverter(mapping);
        Iterator stream = this.valuePairs();
        while (stream.hasNext()) {
            ValuePair valuePair = (ValuePair)stream.next();
            converter.addConversionValue(valuePair.dataValue, valuePair.attributeValue);
        }
        converter.setDefaultAttributeValue(this.getDefaultAttributeValue());
        return converter;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWObjectTypeConverter.class);
        descriptor.getInheritancePolicy().setParentClass(MWTypeConverter.class);
        XMLCompositeCollectionMapping valuePairsMapping = new XMLCompositeCollectionMapping();
        valuePairsMapping.setAttributeName(VALUE_PAIRS_COLLECTION);
        valuePairsMapping.setXPath("value-pairs/value-pair");
        valuePairsMapping.setGetMethodName("getValuePairsForTopLink");
        valuePairsMapping.setSetMethodName("setValuePairsForTopLink");
        valuePairsMapping.setReferenceClass(ValuePair.class);
        descriptor.addMapping((DatabaseMapping)valuePairsMapping);
        descriptor.addDirectMapping("defaultValuePair", "getDefaultAttributeValueForTopLink", "setDefaultAttributeValueForTopLink", "default-attribute-value/text()");
        return descriptor;
    }

    @Override
    public void postProjectBuild() {
        super.postProjectBuild();
        Iterator stream = this.valuePairs();
        while (stream.hasNext()) {
            ValuePair nextPair = (ValuePair)stream.next();
            nextPair.attributeValue = this.buildAttributeValue(nextPair.attributeValue);
            nextPair.dataValue = this.buildDataValue(nextPair.dataValue);
        }
    }

    private Collection getValuePairsForTopLink() {
        return CollectionTools.sort((List)this.valuePairs);
    }

    private void setValuePairsForTopLink(Collection valuePairs) {
        this.valuePairs = valuePairs;
    }

    private Object getDefaultAttributeValueForTopLink() {
        return this.getDefaultAttributeValue();
    }

    private void setDefaultAttributeValueForTopLink(Object defaultAttributeValue) {
        this.defaultValuePair = this.valuePairForAttributeValue(defaultAttributeValue);
    }

    public static class ConversionValueException
    extends Exception {
        private int error;
        private static final int DUPLICATE_DATA_VALUE = 0;
        private static final int DUPLICATE_ATTRIBUTE_VALUE = 1;
        private Object value;

        private ConversionValueException(int error, Object valueObject) {
            this.error = error;
            this.value = valueObject;
        }

        public static ConversionValueException duplicateDataValueException(Object value) {
            return new ConversionValueException(0, value);
        }

        public static ConversionValueException duplicateAttributeValueException(Object value) {
            return new ConversionValueException(1, value);
        }

        public boolean isRepeatedDataValue() {
            return this.error == 0;
        }

        public boolean isRepeatedAttributeValue() {
            return this.error == 1;
        }
    }

    public static class ValuePair
    extends MWModel
    implements Comparable {
        Object dataValue;
        public static final String DATA_VALUE_PROPERTY = "dataValue";
        Object attributeValue;
        public static final String ATTRIBUTE_VALUE_PROPERTY = "attributeValue";
        public static final String DEFAULT_ATTRIBUTE_VALUE_PROPERTY = "defaultAttributeValue";

        private ValuePair() {
        }

        private ValuePair(MWObjectTypeConverter parent, Object dataValue, Object attributeValue) {
            super(parent);
            this.dataValue = dataValue;
            this.attributeValue = attributeValue;
        }

        public Object getDataValue() {
            return this.dataValue;
        }

        public String getDataValueAsString() {
            return (String)ConversionManager.getDefaultManager().convertObject(this.dataValue, String.class);
        }

        private void setDataValue(Object newDataValue) {
            Object oldDataValue = this.dataValue;
            this.dataValue = newDataValue;
            this.firePropertyChanged(DATA_VALUE_PROPERTY, oldDataValue, newDataValue);
        }

        public Object getAttributeValue() {
            return this.attributeValue;
        }

        public String getAttributeValueAsString() {
            return (String)ConversionManager.getDefaultManager().convertObject(this.attributeValue, String.class);
        }

        private void setAttributeValue(Object newAttributeValue) {
            Object oldAttributeValue = this.attributeValue;
            this.attributeValue = newAttributeValue;
            this.firePropertyChanged(ATTRIBUTE_VALUE_PROPERTY, oldAttributeValue, newAttributeValue);
        }

        public boolean isDefaultAttributeValue() {
            return this.attributeValue == this.getObjectTypeConverter().getDefaultAttributeValue();
        }

        public void setDefaultAttributeValue(boolean isNewDefaultValue) {
            boolean isOldDefaultValue;
            ValuePair oldDefaultAttributeValuePair = this.getObjectTypeConverter().defaultValuePair;
            boolean bl = isOldDefaultValue = oldDefaultAttributeValuePair == this;
            if (isNewDefaultValue == isOldDefaultValue) {
                return;
            }
            if (isOldDefaultValue) {
                this.getObjectTypeConverter().setDefaultAttributeValue(null);
            } else if (isNewDefaultValue) {
                if (oldDefaultAttributeValuePair != null) {
                    oldDefaultAttributeValuePair.setDefaultAttributeValue(false);
                }
                this.getObjectTypeConverter().setDefaultAttributeValue(this.attributeValue);
            }
            this.firePropertyChanged(DEFAULT_ATTRIBUTE_VALUE_PROPERTY, isOldDefaultValue, isNewDefaultValue);
        }

        public MWObjectTypeConverter getObjectTypeConverter() {
            return (MWObjectTypeConverter)this.getMWParent();
        }

        @Override
        public int compareTo(Object o) {
            return Collator.getInstance().compare(this.dataValue.toString(), ((ValuePair)o).dataValue.toString());
        }

        public static XMLDescriptor buildDescriptor() {
            XMLDescriptor descriptor = new XMLDescriptor();
            descriptor.setJavaClass(ValuePair.class);
            descriptor.addDirectMapping(DATA_VALUE_PROPERTY, "getDataValueForTopLink", "setDataValueForTopLink", "data-value/text()");
            descriptor.addDirectMapping(ATTRIBUTE_VALUE_PROPERTY, "getAttributeValueForTopLink", "setAttributeValueForTopLink", "attribute-value/text()");
            return descriptor;
        }

        private Object getDataValueForTopLink() {
            return this.getDataValueAsString();
        }

        private void setDataValueForTopLink(Object dataValue) {
            this.dataValue = dataValue;
        }

        private Object getAttributeValueForTopLink() {
            return this.getAttributeValueAsString();
        }

        private void setAttributeValueForTopLink(Object attributeValue) {
            this.attributeValue = attributeValue;
        }

        @Override
        public void toString(StringBuffer sb) {
            sb.append(this.dataValue);
            sb.append(" => ");
            sb.append(this.attributeValue);
        }
    }
}

