/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWReportAttributeItem
extends MWAttributeItem {
    private volatile String name;
    public static final String NAME_PROPERTY = "name";
    private volatile String function;
    public static final String FUNCTION_PROPERTY = "function";
    public static final String AVERAGE_FUNCTION = "Average";
    public static final String COUNT_FUNCTION = "Count";
    public static final String DISTINCT_FUNCTION = "Distinct";
    public static final String MAXIMUM_FUNCTION = "Maximum";
    public static final String MINIMUM_FUNCTION = "Minimum";
    public static final String STANDARD_DEVIATION_FUNCTION = "Standard Deviation";
    public static final String VARIANCE_FUNCTION = "Variance";
    public static final String SUM_FUNCTION = "Sum";
    public static final String NO_FUNCTION = "None";
    public static final String[] FUNCTIONS = new String[]{"None", "Average", "Count", "Distinct", "Maximum", "Minimum", "Sum", "Standard Deviation", "Variance"};

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWReportAttributeItem.class);
        descriptor.getInheritancePolicy().setParentClass(MWAttributeItem.class);
        descriptor.addDirectMapping(NAME_PROPERTY, "item-name/text()");
        AbstractDirectMapping functionMapping = (AbstractDirectMapping)descriptor.addDirectMapping(FUNCTION_PROPERTY, "function/text()");
        ObjectTypeConverter converter = new ObjectTypeConverter((DatabaseMapping)functionMapping);
        converter.addConversionValue((Object)AVERAGE_FUNCTION, (Object)AVERAGE_FUNCTION);
        converter.addConversionValue((Object)COUNT_FUNCTION, (Object)COUNT_FUNCTION);
        converter.addConversionValue((Object)DISTINCT_FUNCTION, (Object)DISTINCT_FUNCTION);
        converter.addConversionValue((Object)MAXIMUM_FUNCTION, (Object)MAXIMUM_FUNCTION);
        converter.addConversionValue((Object)MINIMUM_FUNCTION, (Object)MINIMUM_FUNCTION);
        converter.addConversionValue((Object)STANDARD_DEVIATION_FUNCTION, (Object)STANDARD_DEVIATION_FUNCTION);
        converter.addConversionValue((Object)VARIANCE_FUNCTION, (Object)VARIANCE_FUNCTION);
        converter.addConversionValue((Object)SUM_FUNCTION, (Object)SUM_FUNCTION);
        functionMapping.setConverter((Converter)converter);
        functionMapping.setNullValue((Object)NO_FUNCTION);
        return descriptor;
    }

    private MWReportAttributeItem() {
    }

    MWReportAttributeItem(MWQuery parent, String itemName, MWQueryable queryable) {
        super(parent, queryable);
        this.name = itemName;
    }

    MWReportAttributeItem(MWQuery parent, String itemName, Iterator queryables) {
        super(parent, queryables);
        this.name = itemName;
    }

    MWReportAttributeItem(MWQuery parent, String itemName, Iterator queryables, Iterator allowsNull) {
        super(parent, queryables, allowsNull);
        this.name = itemName;
    }

    @Override
    protected void initialize(Node parentNode) {
        super.initialize(parentNode);
        this.function = NO_FUNCTION;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, this.name);
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String function) {
        String old = this.function;
        this.function = function;
        this.firePropertyChanged(FUNCTION_PROPERTY, old, this.function);
    }

    @Override
    public void removeSelfFromParent() {
        ((MWReportQuery)this.getParentQuery()).removeAttributeItem(this);
    }

    @Override
    public void addQueryableNullProblemTo(List currentProblems) {
        if (this.getFunction() != COUNT_FUNCTION) {
            currentProblems.add(this.queryableNullProblem());
        }
    }

    @Override
    public Problem queryableNullProblem() {
        return this.buildProblem("0259", this.getParentQuery().signature(), this.getName());
    }

    @Override
    public Problem queryableInvalidProblem(MWQueryable queryable) {
        return this.buildProblem("0260", this.getName(), this.getParentQuery().signature());
    }

    @Override
    public boolean isQueryableValid(MWQueryable queryable) {
        return queryable.isValidForReportQueryAttribute();
    }

    @Override
    protected void adjustRuntimeQuery(ObjectLevelReadQuery readQuery) {
        ReportQuery reportQuery = (ReportQuery)readQuery;
        Expression expression = this.getQueryableArgument().runtimeExpression(reportQuery.getExpressionBuilder());
        if (this.getFunction() == NO_FUNCTION) {
            reportQuery.addItem(this.getName(), expression);
        } else if (this.getFunction() == AVERAGE_FUNCTION) {
            reportQuery.addAverage(this.getName(), expression);
        } else if (this.getFunction() == COUNT_FUNCTION) {
            if (this.getName() != null) {
                reportQuery.addCount(this.getName(), expression);
            } else {
                reportQuery.addCount();
            }
        } else if (this.getFunction() == DISTINCT_FUNCTION) {
            reportQuery.addItem(this.getName(), expression.distinct());
        } else if (this.getFunction() == MAXIMUM_FUNCTION) {
            reportQuery.addMaximum(this.getName(), expression);
        } else if (this.getFunction() == MINIMUM_FUNCTION) {
            reportQuery.addMinimum(this.getName(), expression);
        } else if (this.getFunction() == STANDARD_DEVIATION_FUNCTION) {
            reportQuery.addStandardDeviation(this.getName(), expression);
        } else if (this.getFunction() == SUM_FUNCTION) {
            reportQuery.addSum(this.getName(), expression);
        } else if (this.getFunction() == VARIANCE_FUNCTION) {
            reportQuery.addVariance(this.getName(), expression);
        } else {
            reportQuery.addItem(this.getName(), expression.getFunction(this.getFunction()));
        }
    }

    @Override
    public String displayString() {
        if (this.getQueryableArgument().getQueryableArgumentElement().getQueryable() == null && this.getFunction() == COUNT_FUNCTION) {
            return this.getFunction();
        }
        return this.getName() + "->" + super.displayString() + " (" + this.getFunction() + ")";
    }
}

