/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.db;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.WaitDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.CursorConstants;
import org.eclipse.persistence.tools.workbench.framework.uitools.DualListSelectorPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWDatabase;
import org.eclipse.persistence.tools.workbench.mappingsmodel.spi.db.ExternalTableDescription;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class TableImporterDialog
extends AbstractDialog {
    MWDatabase database;
    private static final String DEFAULT_TABLE_NAME_PATTERN = "%";
    private PropertyValueModel tableNamePatternHolder;
    private Document tableNamePatternDocument;
    private JTextField tableNamePatternTextField;
    private JButton tablesButton;
    private String noCatalog;
    private String ignoreCatalog;
    private PropertyValueModel catalogHolder;
    private ComboBoxModel catalogComboBoxModel;
    private String noSchema;
    private String ignoreSchema;
    private PropertyValueModel schemaPatternHolder;
    private ComboBoxModel schemaPatternComboBoxModel;
    private static final String DEFAULT_TABLE_TYPE = "TABLE";
    private String allTableTypes;
    private PropertyValueModel tableTypeHolder;
    private ComboBoxModel tableTypeComboBoxModel;
    private PropertyValueModel fullyQualifiedHolder;
    private ButtonModel fullyQualifiedCheckBoxModel;
    SimpleCollectionValueModel availableExternalTableDescriptionsHolder;
    SimpleCollectionValueModel selectedExternalTableDescriptionsHolder;
    private static final Comparator EXTERNAL_TABLE_DESCRIPTION_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return Collator.getInstance().compare(((ExternalTableDescription)o1).getQualifiedName(), ((ExternalTableDescription)o2).getQualifiedName());
        }
    };

    TableImporterDialog(WorkbenchContext context, MWDatabase database) {
        super(context);
        this.initialize(database);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setTitle(this.resourceRepository().getString("IMPORT_TABLES_FROM_DATABASE_DIALOG.title"));
    }

    @Override
    protected void prepareToShow() {
        this.setSize(700, 500);
        this.setLocationRelativeTo(this.getParent());
        this.getRootPane().setDefaultButton(this.tablesButton);
    }

    private void initialize(MWDatabase db) {
        if (!db.isConnected()) {
            throw new IllegalStateException("database not connected");
        }
        this.database = db;
        this.tableNamePatternHolder = new SimplePropertyValueModel(DEFAULT_TABLE_NAME_PATTERN);
        this.tableNamePatternDocument = new DocumentAdapter(this.tableNamePatternHolder);
        this.tableNamePatternTextField = new JTextField(this.tableNamePatternDocument, null, 0);
        this.ignoreCatalog = this.resourceRepository().getString("IGNORE");
        this.noCatalog = this.resourceRepository().getString("NO_CATALOG");
        this.catalogHolder = new SimplePropertyValueModel(this.ignoreCatalog);
        this.catalogComboBoxModel = new ComboBoxModelAdapter(new ReadOnlyListValueModel(this.buildCatalogs()), this.catalogHolder);
        this.ignoreSchema = this.resourceRepository().getString("IGNORE");
        this.noSchema = this.resourceRepository().getString("NO_SCHEMA");
        this.schemaPatternHolder = new SimplePropertyValueModel(this.ignoreSchema);
        this.schemaPatternComboBoxModel = new ComboBoxModelAdapter(new ReadOnlyListValueModel(this.buildSchemas()), this.schemaPatternHolder);
        this.allTableTypes = this.resourceRepository().getString("ALL_TYPES");
        List tableTypes = this.buildTableTypes();
        this.tableTypeHolder = new SimplePropertyValueModel(tableTypes.contains(DEFAULT_TABLE_TYPE) ? DEFAULT_TABLE_TYPE : this.allTableTypes);
        this.tableTypeComboBoxModel = new ComboBoxModelAdapter(new ReadOnlyListValueModel(tableTypes), this.tableTypeHolder);
        this.fullyQualifiedHolder = new SimplePropertyValueModel(Boolean.FALSE);
        this.fullyQualifiedCheckBoxModel = new CheckBoxModelAdapter(this.fullyQualifiedHolder);
        this.availableExternalTableDescriptionsHolder = new SimpleCollectionValueModel();
        this.selectedExternalTableDescriptionsHolder = new SimpleCollectionValueModel();
    }

    private List buildCatalogs() {
        ArrayList<String> catalogs = new ArrayList<String>();
        catalogs.add(this.ignoreCatalog);
        catalogs.add(this.noCatalog);
        catalogs.addAll(CollectionTools.sortedSet((Iterator)this.database.catalogNames()));
        return catalogs;
    }

    private List buildSchemas() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(this.ignoreSchema);
        schemas.add(this.noSchema);
        schemas.addAll(CollectionTools.sortedSet((Iterator)this.database.schemaNames()));
        return schemas;
    }

    private List buildTableTypes() {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add(this.allTableTypes);
        schemas.addAll(CollectionTools.sortedSet((Iterator)this.database.tableTypeNames()));
        return schemas;
    }

    @Override
    protected String helpTopicId() {
        return "dialog.importingTables";
    }

    @Override
    protected Component initialFocusComponent() {
        return this.tableNamePatternTextField;
    }

    @Override
    protected Component buildMainPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel searchCriteriaPanel = this.buildSearchCriteriaPanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)searchCriteriaPanel, constraints);
        JPanel tableSelectionPanel = this.buildTableSelectionPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        panel.add((Component)tableSelectionPanel, constraints);
        JCheckBox fullyQualifiedCheckBox = this.buildFullyQualifiedCheckBox();
        this.helpManager().addTopicID(fullyQualifiedCheckBox, this.helpTopicId() + ".fullyQualified");
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(10, 0, 5, 0);
        panel.add((Component)fullyQualifiedCheckBox, constraints);
        return panel;
    }

    private JPanel buildSearchCriteriaPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel tableLabel = new JLabel(this.resourceRepository().getString("TABLE_NAME_PATTERN_TEXT_FIELD_LABEL"));
        tableLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TABLE_NAME_PATTERN_TEXT_FIELD_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        panel.add((Component)tableLabel, constraints);
        this.helpManager().addTopicID(this.tableNamePatternTextField, this.helpTopicId() + ".namePattern");
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.tableNamePatternTextField, constraints);
        tableLabel.setLabelFor(this.tableNamePatternTextField);
        JLabel catalogLabel = new JLabel(this.resourceRepository().getString("CATALOG_COMBO_BOX_LABEL"));
        catalogLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("CATALOG_COMBO_BOX_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)catalogLabel, constraints);
        JComboBox catalogComboBox = new JComboBox(this.catalogComboBoxModel);
        this.helpManager().addTopicID(catalogComboBox, this.helpTopicId() + ".catalog");
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add(catalogComboBox, constraints);
        catalogLabel.setLabelFor(catalogComboBox);
        JLabel schemaLabel = new JLabel(this.resourceRepository().getString("SCHEMA_PATTERN_COMBO_BOX_LABEL"));
        schemaLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("SCHEMA_PATTERN_COMBO_BOX_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)schemaLabel, constraints);
        JComboBox schemaComboBox = new JComboBox(this.schemaPatternComboBoxModel);
        schemaComboBox.setEditable(true);
        this.helpManager().addTopicID(schemaComboBox, this.helpTopicId() + ".schemaPattern");
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add(schemaComboBox, constraints);
        schemaLabel.setLabelFor(schemaComboBox);
        JLabel tableTypeLabel = new JLabel(this.resourceRepository().getString("TABLE_TYPE_COMBO_BOX_LABEL"));
        tableTypeLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TABLE_TYPE_COMBO_BOX_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 0, 0, 0);
        panel.add((Component)tableTypeLabel, constraints);
        JComboBox tableTypeComboBox = new JComboBox(this.tableTypeComboBoxModel);
        this.helpManager().addTopicID(tableTypeComboBox, this.helpTopicId() + ".type");
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 5, 0, 0);
        panel.add(tableTypeComboBox, constraints);
        tableTypeLabel.setLabelFor(tableTypeComboBox);
        this.tablesButton = new JButton(this.buildGetTableNamesAction());
        this.tablesButton.setMnemonic(this.resourceRepository().getMnemonic("GET_TABLE_NAMES_BUTTON_TEXT"));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(10, 0, 5, 0);
        panel.add((Component)this.tablesButton, constraints);
        return panel;
    }

    private Action buildGetTableNamesAction() {
        return new AbstractAction(this.resourceRepository().getString("GET_TABLE_NAMES_BUTTON_TEXT")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableImporterDialog.this.getTableNamesPressed();
            }
        };
    }

    private JCheckBox buildFullyQualifiedCheckBox() {
        return SwingComponentFactory.buildCheckBox("FULLY_QUALIFIED_CHECK_BOX", this.fullyQualifiedCheckBoxModel, this.resourceRepository());
    }

    private JPanel buildTableSelectionPanel() {
        DualListSelectorPanel.Builder builder = new DualListSelectorPanel.Builder();
        builder.setAvailableLVM(this.buildSortedExternalTableDescriptionsHolderAdapter(this.availableExternalTableDescriptionsHolder));
        builder.setSelectedLVM(this.buildSortedExternalTableDescriptionsHolderAdapter(this.selectedExternalTableDescriptionsHolder));
        builder.setAdapter(this.buildExternalTableDescriptionSelectionAdapter());
        builder.setListCellRenderer(this.buildExternalTableDescriptionRenderer());
        builder.setContext(this.getApplicationContext());
        builder.setAvailableListBoxLabelKey("AVAILABLE_TABLES_LIST_BOX_LABEL");
        builder.setSelectedListBoxLabelKey("SELECTED_TABLES_LIST_BOX_LABEL");
        builder.setSelectButtonToolTipKey("ADD_SELECTED_TABLES_BUTTON.toolTipText");
        builder.setDeselectButtonToolTipKey("REMOVE_SELECTED_TABLES_BUTTON.toolTipText");
        builder.setHelpTopicID(this.helpTopicId());
        return builder.buildPanel();
    }

    private ListValueModel buildSortedExternalTableDescriptionsHolderAdapter(CollectionValueModel externalTableDescriptionsHolder) {
        return new SortedListValueModelAdapter(externalTableDescriptionsHolder, EXTERNAL_TABLE_DESCRIPTION_COMPARATOR);
    }

    private DualListSelectorPanel.Adapter buildExternalTableDescriptionSelectionAdapter() {
        return new DualListSelectorPanel.Adapter(){

            @Override
            public void select(Object item) {
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.removeItem(item);
                TableImporterDialog.this.selectedExternalTableDescriptionsHolder.addItem(item);
            }

            @Override
            public void deselect(Object item) {
                TableImporterDialog.this.selectedExternalTableDescriptionsHolder.removeItem(item);
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.addItem(item);
            }
        };
    }

    private ListCellRenderer buildExternalTableDescriptionRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return ((ExternalTableDescription)value).getQualifiedName();
            }
        };
    }

    String catalog() {
        String catalog = (String)this.catalogHolder.getValue();
        if (catalog == this.ignoreCatalog) {
            return null;
        }
        if (catalog == this.noCatalog) {
            return "";
        }
        return catalog;
    }

    String schemaPattern() {
        String schema = (String)this.schemaPatternHolder.getValue();
        if (schema == this.ignoreSchema) {
            return null;
        }
        if (schema == this.noSchema) {
            return "";
        }
        return schema;
    }

    String tableNamePattern() {
        return (String)this.tableNamePatternHolder.getValue();
    }

    String[] tableTypes() {
        String tableType = (String)this.tableTypeHolder.getValue();
        if (tableType == this.allTableTypes) {
            return null;
        }
        return new String[]{tableType};
    }

    public boolean importsTablesFullyQualified() {
        return (Boolean)this.fullyQualifiedHolder.getValue();
    }

    public Collection selectedTables() {
        return CollectionTools.list((Iterator)((Iterator)this.selectedExternalTableDescriptionsHolder.getValue()));
    }

    void getTableNamesPressed() {
        Thread thread = new Thread((Runnable)new TableNameQuery(), "Database Table Name Query");
        thread.setPriority(5);
        thread.start();
    }

    void addTableNamesCallback(final Collection tableNames) throws InterruptedException, InvocationTargetException {
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.clear();
                TableImporterDialog.this.availableExternalTableDescriptionsHolder.addItems(tableNames);
            }
        });
    }

    private class TableNameQuery
    implements Runnable {
        TableNameQuery() {
        }

        @Override
        public void run() {
            this.setCursor(CursorConstants.WAIT_CURSOR);
            WaitDialog waitDialog = this.buildWaitDialog();
            AbstractDialog.launchLater(waitDialog);
            ArrayList externalTableDescriptions = new ArrayList(1000);
            try {
                Iterator stream = this.externalTableDescriptions();
                while (stream.hasNext()) {
                    externalTableDescriptions.add(stream.next());
                }
                TableImporterDialog.this.addTableNamesCallback(externalTableDescriptions);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                waitDialog.dispose();
                this.setCursor(CursorConstants.DEFAULT_CURSOR);
            }
        }

        private void setCursor(Cursor cursor) {
            TableImporterDialog.this.getWorkbenchContext().getCurrentWindow().setCursor(cursor);
        }

        private WaitDialog buildWaitDialog() {
            return new WaitDialog((Dialog)TableImporterDialog.this, TableImporterDialog.this.resourceRepository().getIcon("database.large"), TableImporterDialog.this.resourceRepository().getString("GET_TABLE_NAMES_DIALOG.TITLE"), TableImporterDialog.this.resourceRepository().getString("GET_TABLE_NAMES_DIALOG_MESSAGE"));
        }

        private Iterator externalTableDescriptions() {
            return TableImporterDialog.this.database.externalTableDescriptions(TableImporterDialog.this.catalog(), TableImporterDialog.this.schemaPattern(), TableImporterDialog.this.tableNamePattern(), TableImporterDialog.this.tableTypes());
        }
    }
}

