/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveListPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ClassAttributeCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.ClassAttributePanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.chooser.NodeSelector;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class ClassAttributesPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel mwClassHolder;
    PropertyValueModel selectedAttributeHolder;

    ClassAttributesPropertiesPage(PropertyValueModel descriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(descriptorNodeHolder, contextHolder);
    }

    @Override
    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.mwClassHolder = this.buildMWClassHolder();
        this.selectedAttributeHolder = new SimplePropertyValueModel();
    }

    private PropertyValueModel buildMWClassHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDescriptor)this.subject).getMWClass();
            }
        };
    }

    @Override
    protected Component buildPage() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        AddRemoveListPanel attributesListPanel = new AddRemoveListPanel(this.getApplicationContext(), this.buildAddRemoveListPanelAdapter(), this.buildAttributeModifierAdapter(), 2, this.resourceRepository().getString("ATTRIBUTES_LIST"), this.buildAttributeSelector());
        attributesListPanel.setCellRenderer(this.buildAttributesListCellRenderer());
        attributesListPanel.setBorder(this.buildStandardEmptyBorder());
        attributesListPanel.addListSelectionListener(this.buildListSelectionListener(attributesListPanel));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 3;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 0);
        panel.add((Component)attributesListPanel, constraints);
        ClassAttributePanel attributePropertiesPanel = new ClassAttributePanel(this.selectedAttributeHolder, this.getSelectionHolder(), this.getWorkbenchContextHolder());
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 10, 5, 5);
        panel.add((Component)attributePropertiesPanel, constraints);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private NodeSelector buildAttributeSelector() {
        return new NodeSelector(){

            @Override
            public void selectNodeFor(Object item) {
                ProjectNode projectNode = (ProjectNode)ClassAttributesPropertiesPage.this.navigatorSelectionModel().getSelectedProjectNodes()[0];
                projectNode.selectMappingNodeFor((MWClassAttribute)item, ClassAttributesPropertiesPage.this.navigatorSelectionModel());
            }
        };
    }

    private MWClass getMWClass() {
        return (MWClass)this.mwClassHolder.getValue();
    }

    private ListCellRenderer buildAttributesListCellRenderer() {
        return new AdaptableListCellRenderer(new ClassAttributeCellRendererAdapter(this.resourceRepository()));
    }

    private ListSelectionListener buildListSelectionListener(final AddRemoveListPanel attributesListPanel) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (attributesListPanel.getSelectedValues().length > 1) {
                    ClassAttributesPropertiesPage.this.selectedAttributeHolder.setValue(null);
                } else {
                    ClassAttributesPropertiesPage.this.selectedAttributeHolder.setValue(attributesListPanel.getSelectedValue());
                }
            }
        };
    }

    private AddRemovePanel.OptionAdapter buildAddRemoveListPanelAdapter() {
        return new AddRemovePanel.OptionAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                ClassAttributesPropertiesPage.this.addNewAttribute(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                ClassAttributesPropertiesPage.this.removeSelectedAttributes(listSelectionModel);
            }

            @Override
            public void optionOnSelection(ObjectListSelectionModel listSelectionModel) {
                ClassAttributesPropertiesPage.this.renameSelectedAttribute(listSelectionModel);
            }

            @Override
            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel listSelectionModel) {
                return listSelectionModel.getSelectedValuesSize() == 1;
            }

            @Override
            public String optionalButtonKey() {
                return "RENAME_BUTTON";
            }
        };
    }

    void addNewAttribute(ObjectListSelectionModel listSelectionModel) {
        NewNameDialog.Builder newNameDialogBuilder = new NewNameDialog.Builder();
        newNameDialogBuilder.setExistingNames(this.getMWClass().attributeNames());
        newNameDialogBuilder.setIllegalNames(NameTools.javaReservedWords());
        newNameDialogBuilder.setTitle(this.resourceRepository().getString("addNewAttribute.title"));
        newNameDialogBuilder.setTextFieldDescription(this.resourceRepository().getString("enterTheNameOfTheNewAttribute.message"));
        newNameDialogBuilder.setHelpTopicId("dialog.newAttribute");
        newNameDialogBuilder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            @Override
            public Document buildDocument() {
                return new RegexpDocument(6);
            }
        });
        NewNameDialog newNameDialog = newNameDialogBuilder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (!newNameDialog.wasConfirmed()) {
            return;
        }
        MWClassAttribute newAttribute = this.getMWClass().addAttribute(newNameDialog.getNewName());
        listSelectionModel.setSelectedValue(newAttribute);
    }

    private CollectionValueModel buildAttributesHolder() {
        return new CollectionAspectAdapter(this.mwClassHolder, "attributes"){

            @Override
            protected Iterator getValueFromSubject() {
                return ((MWClass)this.subject).attributes();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWClass)this.subject).attributesSize();
            }
        };
    }

    private ItemPropertyListValueModelAdapter buildAttributeModifierAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildSortedAttributesListValueModelAdapter(), "modifierAccessLevel", "declaration");
    }

    private SortedListValueModelAdapter buildSortedAttributesListValueModelAdapter() {
        return new SortedListValueModelAdapter(this.buildAttributeNameAdapter());
    }

    private ItemPropertyListValueModelAdapter buildAttributeNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildAttributesHolder(), "name");
    }

    void removeSelectedAttributes(ObjectListSelectionModel listSelectionModel) {
        this.getMWClass().removeAttributes(CollectionTools.collection((Object[])listSelectionModel.getSelectedValues()));
    }

    void renameSelectedAttribute(ObjectListSelectionModel listSelectionModel) {
        MWClassAttribute selectedAttribute = (MWClassAttribute)listSelectionModel.getSelectedValue();
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setExistingNames(selectedAttribute.getDeclaringType().attributeNames());
        builder.setOriginalName(selectedAttribute.getName());
        builder.setIllegalNames(NameTools.javaReservedWords());
        builder.setTextFieldDescription(this.resourceRepository().getString("renameAttribute.message"));
        builder.setTitle(this.resourceRepository().getString("renameAttribute.title"));
        builder.setHelpTopicId("dialog.attributeRename");
        builder.setDocumentFactory(new NewNameDialog.DocumentFactory(){

            @Override
            public Document buildDocument() {
                return new RegexpDocument(6);
            }
        });
        NewNameDialog newNameDialog = builder.buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        String newName = newNameDialog.getNewName();
        this.navigatorSelectionModel().pushExpansionState();
        selectedAttribute.setName(newName);
        listSelectionModel.setSelectedValue(selectedAttribute);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
    }

    private String helpTopicId() {
        return "descriptor.classInfo.attributes";
    }
}

