/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsplugin.AutomappableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.RemovableNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.MappingsApplicationNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.DescriptorPackagePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RenamePackageAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmapAllDescriptorsInPackageAction;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.UnmappablePackageNode;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.ProjectNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public abstract class DescriptorPackageNode
extends MappingsApplicationNode
implements ProjectNode.Child,
UnmappablePackageNode,
AutomappableNode,
RemovableNode {
    private String name;
    private DescriptorNodeBuilder descriptorNodeBuilder;
    private SimpleCollectionValueModel descriptorNodesHolder;
    private ListValueModel childrenModel;
    private boolean descriptorNodeHasBeenRemoved;
    private PropertyChangeListener projectNodeDirtyFlagListener;

    protected DescriptorPackageNode(String name, ProjectNode parent, DescriptorNodeBuilder descriptorNodeBuilder) {
        super((MWModel)null, (TreeNodeValueModel)parent, parent.getPlugin(), parent.getApplicationContext());
        this.name = name;
        this.descriptorNodeBuilder = descriptorNodeBuilder;
    }

    protected void initialize() {
        super.initialize();
        this.descriptorNodesHolder = new SimpleCollectionValueModel();
        this.childrenModel = this.buildChildrenModel();
        this.descriptorNodeHasBeenRemoved = false;
        this.projectNodeDirtyFlagListener = this.buildProjectNodeDirtyFlagListener();
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDescriptorsDisplayStringAdapter());
    }

    protected ListValueModel buildDescriptorsDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter((CollectionValueModel)this.descriptorNodesHolder, "displayString");
    }

    protected PropertyChangeListener buildProjectNodeDirtyFlagListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DescriptorPackageNode.this.projectNodeDirtyFlagChanged(e);
            }

            public String toString() {
                return "project node dirty flag listener";
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        DescriptorPackageNode other = (DescriptorPackageNode)o;
        return this.getParent().equals(other.getParent()) && this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    @Override
    public String helpTopicID() {
        return "package";
    }

    @Override
    protected String buildDisplayString() {
        return this.name == null ? "" : (this.name.length() == 0 ? this.resourceRepository().getString("DEFAULT_PACKAGE") : this.name);
    }

    @Override
    protected String buildIconKey() {
        return "package";
    }

    @Override
    protected boolean buildDirtyFlag() {
        Iterator stream = this.descriptors();
        while (stream.hasNext()) {
            if (!((MWDescriptor)stream.next()).isDirtyBranch()) continue;
            return true;
        }
        return this.descriptorNodeHasBeenRemoved;
    }

    @Override
    protected boolean valueHasBranchProblems() {
        Iterator stream = this.descriptors();
        while (stream.hasNext()) {
            if (!((MWDescriptor)stream.next()).hasBranchProblems()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addExclusiveApplicationProblemsTo(List list) {
    }

    @Override
    public boolean containsBranchApplicationProblemFor(Problem problem) {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            if (!((DescriptorNode)stream.next()).containsBranchApplicationProblemFor(problem)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void engageValueDisplayString() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.engageDescriptorNodeDisplayString((DescriptorNode)stream.next());
        }
        this.rebuildDisplayString();
    }

    protected void engageDescriptorNodeDisplayString(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("displayString", this.getValueDisplayStringListener());
    }

    @Override
    protected void engageValueIcon() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.engageDescriptorNodeIcon((DescriptorNode)stream.next());
        }
        this.rebuildIconBuilder();
        this.rebuildIcon();
    }

    protected void engageDescriptorNodeIcon(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("icon", this.getValueIconListener());
    }

    @Override
    protected void engageValueDirty() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.engageDescriptorNodeDirty((DescriptorNode)stream.next());
        }
        this.getProjectNode().addPropertyChangeListener("dirty", this.projectNodeDirtyFlagListener);
        this.rebuildDirtyFlag();
    }

    protected void engageDescriptorNodeDirty(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("dirty", this.getValueDirtyListener());
    }

    @Override
    protected void engageValuePropertiesPageTitleIcon() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.engageDescriptorNodePropertiesPageTitleIcon((DescriptorNode)stream.next());
        }
        this.rebuildPropertiesPageTitleIconBuilder();
        this.rebuildPropertiesPageTitleIcon();
    }

    protected void engageDescriptorNodePropertiesPageTitleIcon(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("propertiesPageTitleIcon", this.getValuePropertiesPageTitleIconListener());
    }

    @Override
    protected void engageValuePropertiesPageTitleText() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.engageDescriptorNodePropertiesPageTitleText((DescriptorNode)stream.next());
        }
        this.rebuildPropertiesPageTitleText();
    }

    protected void engageDescriptorNodePropertiesPageTitleText(DescriptorNode descriptorNode) {
        descriptorNode.addPropertyChangeListener("propertiesPageTitleText", this.getValuePropertiesPageTitleTextListener());
    }

    @Override
    protected void engageValueBranchProblems() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.engageDescriptorNodeBranchProblems((DescriptorNode)stream.next());
        }
        this.rebuildApplicationProblems();
        this.rebuildBranchApplicationProblems();
    }

    protected void engageDescriptorNodeBranchProblems(DescriptorNode descriptorNode) {
        descriptorNode.addListChangeListener("branchApplicationProblems", this.getValueBranchProblemsListener());
    }

    @Override
    protected void disengageValueDisplayString() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.disengageDescriptorNodeDisplayString((DescriptorNode)stream.next());
        }
    }

    protected void disengageDescriptorNodeDisplayString(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("displayString", this.getValueDisplayStringListener());
    }

    @Override
    protected void disengageValueIcon() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.disengageDescriptorNodeIcon((DescriptorNode)stream.next());
        }
    }

    protected void disengageDescriptorNodeIcon(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("icon", this.getValueIconListener());
    }

    @Override
    protected void disengageValueDirty() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.disengageDescriptorNodeDirty((DescriptorNode)stream.next());
        }
        this.getProjectNode().removePropertyChangeListener("dirty", this.projectNodeDirtyFlagListener);
    }

    protected void disengageDescriptorNodeDirty(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("dirty", this.getValueDirtyListener());
    }

    @Override
    protected void disengageValuePropertiesPageTitleIcon() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.disengageDescriptorNodePropertiesPageTitleIcon((DescriptorNode)stream.next());
        }
    }

    protected void disengageDescriptorNodePropertiesPageTitleIcon(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("propertiesPageTitleIcon", this.getValuePropertiesPageTitleIconListener());
    }

    @Override
    protected void disengageValuePropertiesPageTitleText() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.disengageDescriptorNodePropertiesPageTitleText((DescriptorNode)stream.next());
        }
    }

    protected void disengageDescriptorNodePropertiesPageTitleText(DescriptorNode descriptorNode) {
        descriptorNode.removePropertyChangeListener("propertiesPageTitleText", this.getValuePropertiesPageTitleTextListener());
    }

    @Override
    protected void disengageValueBranchProblems() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            this.disengageDescriptorNodeBranchProblems((DescriptorNode)stream.next());
        }
    }

    protected void disengageDescriptorNodeBranchProblems(DescriptorNode descriptorNode) {
        descriptorNode.removeListChangeListener("branchApplicationProblems", this.getValueBranchProblemsListener());
    }

    @Override
    public void addValuePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    @Override
    public void removeValuePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
    }

    @Override
    public String accessibleName() {
        if (this.name == null || this.name.length() == 0) {
            return this.resourceRepository().getString("DEFAULT_PACKAGE");
        }
        return this.resourceRepository().getString("ACCESSIBLE_PACKAGE_NODE", this.displayString());
    }

    @Override
    protected Class propertiesPageClass() {
        return DescriptorPackagePropertiesPage.class;
    }

    @Override
    public String candidatePackageName() {
        return this.name;
    }

    @Override
    public boolean isAutoMappable() {
        return true;
    }

    @Override
    public void addDescriptorsTo(Collection descriptors) {
        CollectionTools.addAll((Collection)descriptors, (Iterator)this.descriptors());
    }

    public Iterator descriptors() {
        return new TransformationIterator(this.descriptorNodes()){

            protected Object transform(Object next) {
                return ((DescriptorNode)next).getDescriptor();
            }
        };
    }

    @Override
    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        RootMenuDescription desc = new RootMenuDescription();
        this.addToMenuDescription(desc, this.buildLocalWorkbenchContext(workbenchContext));
        return desc;
    }

    protected abstract void addToMenuDescription(GroupContainerDescription var1, WorkbenchContext var2);

    protected MenuGroupDescription buildClassActionGroup(WorkbenchContext context) {
        MenuGroupDescription classActionGroup = new MenuGroupDescription();
        classActionGroup.add(this.getMappingsPlugin().getRefreshClassesAction(context));
        classActionGroup.add(this.getMappingsPlugin().getAddOrRefreshClassesAction(context));
        classActionGroup.add(this.getMappingsPlugin().getCreateNewClassAction(context));
        return classActionGroup;
    }

    protected MenuGroupDescription buildRemoveActionGroup(WorkbenchContext context) {
        MenuGroupDescription removeActionGroup = new MenuGroupDescription();
        removeActionGroup.add(this.getMappingsPlugin().getRemoveAction(context));
        removeActionGroup.add(this.getRenamePackageAction(context));
        return removeActionGroup;
    }

    protected MenuGroupDescription buildUnmapActionGroup(WorkbenchContext context) {
        MenuGroupDescription unMapGroup = new MenuGroupDescription();
        unMapGroup.add(this.getUnmapAllDescriptorsInPackageAction(context));
        return unMapGroup;
    }

    protected MenuGroupDescription buildExportJavaSourceActionGroup(WorkbenchContext context) {
        MenuGroupDescription exportJavaSourceGroup = new MenuGroupDescription();
        exportJavaSourceGroup.add(this.getMappingsPlugin().getExportSpecificDescriptorModelJavaSourceAction(context));
        return exportJavaSourceGroup;
    }

    @Override
    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        return new ToolBarDescription();
    }

    private FrameworkAction getUnmapAllDescriptorsInPackageAction(WorkbenchContext context) {
        return new UnmapAllDescriptorsInPackageAction(context);
    }

    private FrameworkAction getRenamePackageAction(WorkbenchContext context) {
        return new RenamePackageAction(context);
    }

    @Override
    public int getProjectNodeChildPriority() {
        return 0;
    }

    @Override
    public String getAutomapSuccessfulStringKey() {
        return "AUTOMAP_PACKAGE_SUCCESSFUL";
    }

    @Override
    public void unmapEntirePackage() {
        this.unmap();
    }

    public void unmap() {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            ((DescriptorNode)stream.next()).unmap();
        }
    }

    @Override
    public void remove() {
        Iterator stream = CollectionTools.collection((Iterator)this.descriptorNodes()).iterator();
        while (stream.hasNext()) {
            ((DescriptorNode)stream.next()).remove();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Iterator descriptorNodes() {
        return (Iterator)this.descriptorNodesHolder.getValue();
    }

    public int descriptorNodesSize() {
        return this.descriptorNodesHolder.size();
    }

    private void addDescriptorNode(DescriptorNode descriptorNode) {
        this.descriptorNodesHolder.addItem(descriptorNode);
    }

    private void removeDescriptorNode(DescriptorNode descriptorNode) {
        this.descriptorNodesHolder.removeItem(descriptorNode);
    }

    public DescriptorNode descriptorNodeFor(MWDescriptor descriptor) {
        Iterator stream = this.descriptorNodes();
        while (stream.hasNext()) {
            DescriptorNode node = (DescriptorNode)stream.next();
            if (node.getDescriptor() != descriptor) continue;
            return node;
        }
        return null;
    }

    public void addDescriptorNodeFor(MWDescriptor descriptor) {
        DescriptorNode descriptorNode = this.descriptorNodeBuilder.buildDescriptorNode(descriptor, this);
        this.addDescriptorNode(descriptorNode);
        boolean hasAnyStateChangeListeners = this.hasAnyStateChangeListeners();
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("displayString")) {
            this.engageDescriptorNodeDisplayString(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("icon")) {
            this.engageDescriptorNodeIcon(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("dirty")) {
            this.engageDescriptorNodeDirty(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.engageDescriptorNodePropertiesPageTitleIcon(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("propertiesPageTitleText")) {
            this.engageDescriptorNodePropertiesPageTitleText(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyListChangeListeners("branchApplicationProblems")) {
            this.engageDescriptorNodeBranchProblems(descriptorNode);
        }
        this.iconChanged();
        this.dirtyChanged();
        this.propertiesPageTitleIconChanged();
        this.propertiesPageTitleTextChanged();
        this.branchProblemsChanged();
    }

    public void removeDescriptorNodeFor(MWDescriptor descriptor) {
        DescriptorNode descriptorNode = this.descriptorNodeFor(descriptor);
        boolean hasAnyStateChangeListeners = this.hasAnyStateChangeListeners();
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("displayString")) {
            this.disengageDescriptorNodeDisplayString(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("icon")) {
            this.disengageDescriptorNodeIcon(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("dirty")) {
            this.disengageDescriptorNodeDirty(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("propertiesPageTitleIcon")) {
            this.disengageDescriptorNodePropertiesPageTitleIcon(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyPropertyChangeListeners("propertiesPageTitleText")) {
            this.disengageDescriptorNodePropertiesPageTitleText(descriptorNode);
        }
        if (hasAnyStateChangeListeners || this.hasAnyListChangeListeners("branchApplicationProblems")) {
            this.disengageDescriptorNodeBranchProblems(descriptorNode);
        }
        this.removeDescriptorNode(descriptorNode);
        this.descriptorNodeHasBeenRemoved = true;
        this.iconChanged();
        this.dirtyChanged();
        this.propertiesPageTitleIconChanged();
        this.propertiesPageTitleTextChanged();
        this.branchProblemsChanged();
    }

    void projectNodeDirtyFlagChanged(PropertyChangeEvent e) {
        boolean oldDirtyFlagValue = (Boolean)e.getOldValue();
        boolean newDirtyFlagValue = (Boolean)e.getNewValue();
        if (oldDirtyFlagValue && !newDirtyFlagValue) {
            this.descriptorNodeHasBeenRemoved = false;
            this.dirtyChanged();
        }
    }

    public static interface DescriptorNodeBuilder {
        public DescriptorNode buildDescriptorNode(MWDescriptor var1, DescriptorPackageNode var2);
    }
}

