/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.chooser.ClassChooserPanel;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractSubjectPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.DefaultingContainerClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectMapContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWRelationalDirectMapMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassRepository;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassChooserTools;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.meta.ClassRepositoryHolder;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;

public final class DirectMapContainerPolicyPanel
extends AbstractSubjectPanel {
    private PropertyValueModel directMapContainerPolicyHolder;
    private PropertyValueModel defaultingContainerClassHolder;

    public DirectMapContainerPolicyPanel(PropertyValueModel directMapMappingHolder, WorkbenchContextHolder contextHolder) {
        super((ValueModel)directMapMappingHolder, contextHolder);
    }

    @Override
    protected void initialize(ValueModel subjectHolder) {
        super.initialize(subjectHolder);
        this.directMapContainerPolicyHolder = this.buildDirectMapContainerPolicyHolder();
        this.defaultingContainerClassHolder = this.buildDefaultingContainerClassHolder();
    }

    private PropertyValueModel buildDefaultingContainerClassHolder() {
        return new PropertyAspectAdapter(this.directMapContainerPolicyHolder){

            @Override
            protected Object getValueFromSubject() {
                return ((MWDirectMapContainerPolicy)this.subject).getDefaultingContainerClass();
            }
        };
    }

    private ClassRepositoryHolder buildClassRepositoryHolder() {
        return new ClassRepositoryHolder(){

            @Override
            public MWClassRepository getClassRepository() {
                return ((MWModel)DirectMapContainerPolicyPanel.this.subject()).getRepository();
            }
        };
    }

    private ItemListener buildContainerClassChooserEnabler(final ClassChooserPanel containerClassChooserPanel) {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                containerClassChooserPanel.setEnabled(e.getStateChange() == 1);
            }
        };
    }

    private PropertyValueModel buildDirectMapContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "containerClass"){

            @Override
            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).getContainerClass();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DefaultingContainerClass)this.subject).setContainerClass((MWClass)value);
            }
        };
    }

    private PropertyValueModel buildDirectMapContainerPolicyHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "containerPolicy"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalDirectMapMapping)this.subject).getContainerPolicy();
            }
        };
    }

    private ButtonModel buildOverrideDefaultClassCheckBoxAdapter() {
        return new CheckBoxModelAdapter(this.buildOverrideDefaultClassHolder());
    }

    private PropertyValueModel buildOverrideDefaultClassHolder() {
        return new TransformationPropertyValueModel(this.buildUseDefaultContainerClassHolder()){

            private Boolean oppositeValue(Boolean value) {
                return value == null ? null : Boolean.valueOf(value == false);
            }

            @Override
            protected Object reverseTransform(Object value) {
                return this.oppositeValue((Boolean)value);
            }

            @Override
            protected Object transform(Object value) {
                return this.oppositeValue((Boolean)value);
            }
        };
    }

    private PropertyValueModel buildUseDefaultContainerClassHolder() {
        return new PropertyAspectAdapter(this.defaultingContainerClassHolder, "usesDefaultContainerClass"){

            @Override
            protected Object getValueFromSubject() {
                return ((DefaultingContainerClass)this.subject).usesDefaultContainerClass();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((DefaultingContainerClass)this.subject).setUseDefaultContainerClass(((Boolean)value).booleanValue());
            }
        };
    }

    @Override
    protected void initializeLayout() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        GridBagConstraints constraints = new GridBagConstraints();
        JCheckBox customClassCheckBox = this.buildCheckBox("COLLECTION_CONTAINER_POLICY_OVERRIDE_DEFAULT_CLASS_CHECK_BOX", this.buildOverrideDefaultClassCheckBoxAdapter());
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)customClassCheckBox, constraints);
        this.addAlignLeft(customClassCheckBox);
        ClassChooserPanel containerClassChooserPanel = ClassChooserTools.buildPanel(this.buildDirectMapContainerClassHolder(), this.buildClassRepositoryHolder(), ClassChooserTools.buildDeclarableReferenceFilter(), new JLabel(this.resourceRepository().getString("COLLECTION_CONTAINER_POLICY_OVERRIDE_DEFAULT_CLASS_CHECK_BOX")), this.getWorkbenchContextHolder());
        containerClassChooserPanel.setEnabled(customClassCheckBox.isSelected());
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)containerClassChooserPanel, constraints);
        this.addPaneForAlignment(containerClassChooserPanel);
        customClassCheckBox.addItemListener(this.buildContainerClassChooserEnabler(containerClassChooserPanel));
        this.addHelpTopicId(this, "mapping.containerPolicy");
    }
}

