/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWCustomReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWDeleteQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWInsertQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWUpdateQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.CustomQuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class RelationalCustomSqlPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel queryManagerHolder;

    public RelationalCustomSqlPropertiesPage(PropertyValueModel relationalDescriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(relationalDescriptorNodeHolder, contextHolder);
    }

    @Override
    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.queryManagerHolder = this.buildQueryManagerHolder();
    }

    private PropertyValueModel buildQueryManagerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            @Override
            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getQueryManager();
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.customSQL";
    }

    @Override
    protected Component buildPage() {
        this.setName("Queries");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JTabbedPane sqlStringTabbedPane = new JTabbedPane();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)sqlStringTabbedPane, constraints);
        JComponent insertSQLPane = this.buildInsertQueryPanel();
        insertSQLPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), insertSQLPane.getBorder()));
        this.addHelpTopicId(insertSQLPane, this.helpTopicId() + ".insert");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_INSERT_TAB"), insertSQLPane);
        JComponent updateSQLPane = this.buildUpdateQueryPanel();
        updateSQLPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), updateSQLPane.getBorder()));
        this.addHelpTopicId(updateSQLPane, this.helpTopicId() + ".update");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_UPDATE_TAB"), updateSQLPane);
        JComponent deleteSQLPane = this.buildDeleteQueryPanel();
        deleteSQLPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), deleteSQLPane.getBorder()));
        this.addHelpTopicId(deleteSQLPane, this.helpTopicId() + ".delete");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_DELETE_TAB"), deleteSQLPane);
        JComponent readObjectSQLPane = this.buildReadObjectQueryPanel();
        readObjectSQLPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), readObjectSQLPane.getBorder()));
        this.addHelpTopicId(readObjectSQLPane, this.helpTopicId() + ".readObject");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_READ_OBJECT_TAB"), readObjectSQLPane);
        JComponent readAllSQLPane = this.buildReadAllQueryPanel();
        readAllSQLPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), readAllSQLPane.getBorder()));
        this.addHelpTopicId(readAllSQLPane, this.helpTopicId() + ".readAll");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_QUERY_READ_ALL_TAB"), readAllSQLPane);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private JComponent buildInsertQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildInsertQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildInsertQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "insertQuery"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getInsertQuery();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setInsertQuery((MWInsertQuery)value);
            }
        };
    }

    private JComponent buildUpdateQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildUpdateQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildUpdateQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "updateQuery"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getUpdateQuery();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setUpdateQuery((MWUpdateQuery)value);
            }
        };
    }

    private JComponent buildDeleteQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildDeleteQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildDeleteQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "deleteQuery"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getDeleteQuery();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setDeleteQuery((MWDeleteQuery)value);
            }
        };
    }

    private JComponent buildReadObjectQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildReadObjectQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildReadObjectQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readObjectQuery"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadObjectQuery();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setReadObjectQuery((MWCustomReadObjectQuery)value);
            }
        };
    }

    private JComponent buildReadAllQueryPanel() {
        return new CustomQuerySelectionCriteriaPanel(this.buildReadAllQueryHolder(), this.getWorkbenchContextHolder());
    }

    private PropertyValueModel buildReadAllQueryHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readAllQuery"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadAllQuery();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setReadAllQuery((MWCustomReadAllQuery)value);
            }
        };
    }

    private JTextArea buildTextArea(PropertyValueModel stringHolder) {
        JTextArea textArea = new JTextArea(new DocumentAdapter(stringHolder));
        textArea.setFont(new Font("dialog", 0, 12));
        return textArea;
    }
}

